/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentReader;

class ReportContentReaderV1
implements IReportContentReader {
    protected static Logger logger = Logger.getLogger(ReportContentReaderV1.class.getName());
    protected IReportDocument document;
    protected ReportContent reportContent;
    protected RAInputStream stream;
    protected long offset;
    protected ClassLoader loader;

    public ReportContentReaderV1(ReportContent reportContent, IReportDocument document, ClassLoader loader) {
        this.reportContent = reportContent;
        this.document = document;
        this.loader = loader;
    }

    @Override
    public void open(String name) throws IOException {
        IDocArchiveReader reader = this.document.getArchive();
        this.stream = reader.getStream(name);
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the reader", ex);
            }
        }
    }

    protected IContent readContent(DataInputStream oi) throws IOException {
        int contentType = IOUtil.readInt(oi);
        switch (contentType) {
            case 1: {
                CellContent cellContent = (CellContent)this.reportContent.createCellContent();
                cellContent.readContent(oi, this.loader);
                return cellContent;
            }
            case 2: {
                ContainerContent containerContent = (ContainerContent)this.reportContent.createContainerContent();
                containerContent.readContent(oi, this.loader);
                return containerContent;
            }
            case 3: {
                DataContent dataContent = (DataContent)this.reportContent.createDataContent();
                dataContent.readContent(oi, this.loader);
                return dataContent;
            }
            case 4: {
                ForeignContent foreignContent = (ForeignContent)this.reportContent.createForeignContent();
                foreignContent.readContent(oi, this.loader);
                return foreignContent;
            }
            case 5: {
                ImageContent imageContent = (ImageContent)this.reportContent.createImageContent();
                imageContent.readContent(oi, this.loader);
                return imageContent;
            }
            case 6: {
                LabelContent labelContent = (LabelContent)this.reportContent.createLabelContent();
                labelContent.readContent(oi, this.loader);
                return labelContent;
            }
            case 7: {
                PageContent pageContent = (PageContent)this.reportContent.createPageContent();
                pageContent.readContent(oi, this.loader);
                return pageContent;
            }
            case 8: {
                RowContent rowContent = (RowContent)this.reportContent.createRowContent();
                rowContent.readContent(oi, this.loader);
                return rowContent;
            }
            case 9: {
                TableBandContent tableBandContent = (TableBandContent)this.reportContent.createTableBandContent();
                tableBandContent.readContent(oi, this.loader);
                return tableBandContent;
            }
            case 10: {
                TableContent tableContent = (TableContent)this.reportContent.createTableContent();
                tableContent.readContent(oi, this.loader);
                return tableContent;
            }
            case 11: {
                TextContent textContent = (TextContent)this.reportContent.createTextContent();
                textContent.readContent(oi, this.loader);
                return textContent;
            }
            case 12: {
                AutoTextContent autoText = (AutoTextContent)this.reportContent.createAutoTextContent();
                autoText.readContent(oi, this.loader);
                return autoText;
            }
        }
        throw new IOException("No a valid content type: " + contentType);
    }

    @Override
    public IContent readContent() throws IOException {
        this.stream.seek(this.offset);
        int size = this.stream.readInt();
        this.offset += 4L;
        this.offset += (long)size;
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        return this.readContent(oi);
    }

    public IContent readContent(long offset) throws IOException {
        if (offset >= (long)this.stream.available()) {
            return null;
        }
        this.stream.seek(offset);
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        IContent content = this.readContent(oi);
        DocumentExtension ext = new DocumentExtension(offset);
        content.setExtension(0, ext);
        return content;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }
}

