/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;

public class RecordStore {
    private transient URL url;
    protected transient int numRecords;
    protected transient int numObjects;
    public transient int lastObjectIdx;
    protected transient int vpX;
    protected transient int vpY;
    protected transient int vpW;
    protected transient int vpH;
    protected transient Vector records;
    protected transient Vector objectVector;
    protected transient boolean bReading = false;

    public RecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0;
        this.vpY = 0;
        this.vpW = 1000;
        this.vpH = 1000;
        this.numObjects = 0;
        this.records = new Vector(20, 20);
        this.objectVector = new Vector();
    }

    synchronized void setReading(boolean bl) {
        this.bReading = bl;
    }

    synchronized boolean isReading() {
        return this.bReading;
    }

    public boolean read(DataInputStream dataInputStream) throws IOException {
        this.setReading(true);
        this.reset();
        int n = 0;
        this.numRecords = 0;
        this.numObjects = dataInputStream.readShort();
        this.objectVector.ensureCapacity(this.numObjects);
        int n2 = 0;
        while (n2 < this.numObjects) {
            this.objectVector.addElement(new GdiObject(n2, false));
            ++n2;
        }
        while (n != -1) {
            MetaRecord metaRecord;
            int n3;
            n = dataInputStream.readShort();
            if (n == -1) break;
            switch (n) {
                case 763: 
                case 1313: 
                case 1583: 
                case 2610: {
                    n3 = dataInputStream.readShort();
                    byte[] byArray = new byte[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = dataInputStream.readByte();
                        ++n4;
                    }
                    String string = new String(byArray);
                    metaRecord = new StringRecord(string);
                    break;
                }
                default: {
                    metaRecord = new MetaRecord();
                }
            }
            n3 = dataInputStream.readShort();
            metaRecord.numPoints = n3;
            metaRecord.functionId = n;
            int n5 = 0;
            while (n5 < n3) {
                metaRecord.AddElement(new Integer(dataInputStream.readShort()));
                ++n5;
            }
            this.records.addElement(metaRecord);
            ++this.numRecords;
        }
        this.setReading(false);
        return true;
    }

    public void addObject(int n, Object object) {
        int n2 = 0;
        while (n2 < this.numObjects) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(n2);
            if (!gdiObject.used) {
                gdiObject.Setup(n, object);
                this.lastObjectIdx = n2;
                break;
            }
            ++n2;
        }
    }

    public void addObjectAt(int n, Object object, int n2) {
        if (n2 == 0 || n2 > this.numObjects) {
            this.addObject(n, object);
            return;
        }
        this.lastObjectIdx = n2;
        int n3 = 0;
        while (n3 < this.numObjects) {
            GdiObject gdiObject = (GdiObject)this.objectVector.elementAt(n3);
            if (n3 == n2) {
                gdiObject.Setup(n, object);
                break;
            }
            ++n3;
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public GdiObject getObject(int n) {
        return (GdiObject)this.objectVector.elementAt(n);
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.elementAt(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public int getNumObjects() {
        return this.numObjects;
    }

    public int getVpX() {
        return this.vpX;
    }

    public int getVpY() {
        return this.vpY;
    }

    public int getVpW() {
        return this.vpW;
    }

    public int getVpH() {
        return this.vpH;
    }

    public void setVpX(int n) {
        this.vpX = n;
    }

    public void setVpY(int n) {
        this.vpY = n;
    }

    public void setVpW(int n) {
        this.vpW = n;
    }

    public void setVpH(int n) {
        this.vpH = n;
    }
}

