/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceNoDbImpl;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeLog;
import org.nuiton.util.Version;

public class PersistenceService
extends AbstractTuttiService
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(PersistenceService.class);
    protected TuttiPersistence driver;
    public static final DateFormat EXPORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String EXPORT_DIRECTORY_FORMAT = "tutti-%s-%s";
    public static final TimeLog TIME_LOG = new TimeLog(PersistenceService.class);

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.init();
    }

    public FrequencyFunction<SpeciesBatch, SpeciesBatchFrequency> newSpeciesFrequenciesFunction() {
        return new FrequencyFunction<SpeciesBatch, SpeciesBatchFrequency>(){

            public List<SpeciesBatchFrequency> apply(SpeciesBatch input) {
                return PersistenceService.this.getAllSpeciesBatchFrequency(input.getId());
            }
        };
    }

    public FrequencyFunction<BenthosBatch, BenthosBatchFrequency> newBenthosFrequenciesFunction() {
        return new FrequencyFunction<BenthosBatch, BenthosBatchFrequency>(){

            public List<BenthosBatchFrequency> apply(BenthosBatch input) {
                return PersistenceService.this.getAllBenthosBatchFrequency(input.getId());
            }
        };
    }

    public <F extends SpeciesAbleBatchFrequency> Float countFrequenciesWeight(List<F> frequencies, boolean stopIfNullFound) {
        Float result = null;
        for (SpeciesAbleBatchFrequency frequency : frequencies) {
            Float w = frequency.getWeight();
            if (w == null) {
                if (!stopIfNullFound) continue;
                break;
            }
            if (result == null) {
                result = Float.valueOf(0.0f);
            }
            result = Float.valueOf(result.floatValue() + w.floatValue());
        }
        return result;
    }

    public <F extends SpeciesAbleBatchFrequency> Integer countFrequenciesNumber(List<F> frequencies, boolean stopIfNullFound) {
        Integer result = null;
        for (SpeciesAbleBatchFrequency frequency : frequencies) {
            Integer number = frequency.getNumber();
            if (number == null) {
                if (!stopIfNullFound) continue;
                break;
            }
            if (result == null) {
                result = 0;
            }
            result = result + number;
        }
        return result;
    }

    public String getImplementationName() {
        return "Tutti Persistence Service";
    }

    public void clearAllCaches() {
        this.driver.clearAllCaches();
    }

    public TuttiEnumerationFile getEnumerationFile() {
        return this.driver.getEnumerationFile();
    }

    public <V> V invoke(Callable<V> call) {
        return (V)this.driver.invoke(call);
    }

    public Version getDbVersion() {
        return this.driver.getDbVersion();
    }

    public Version getApplicationVersion() {
        return this.driver.getApplicationVersion();
    }

    public void updateSchema() {
        this.driver.updateSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDb(File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiServiceConfig config = this.context.getConfig();
        String directoryName = String.format(EXPORT_DIRECTORY_FORMAT, config.getVersion(), EXPORT_DATE_FORMAT.format(this.context.currentDate()));
        File structureDirectory = new File(config.newTempFile("exportdb"), directoryName);
        try {
            TuttiIOUtil.forceMkdir((File)structureDirectory, (String)I18n._((String)"tutti.service.mkDir.error", (Object[])new Object[]{structureDirectory}));
            if (log.isInfoEnabled()) {
                log.info((Object)("Export directory: " + structureDirectory));
            }
            TuttiPersistenceConfig pConfig = config.getPersistenceConfig();
            TuttiIOUtil.copyDirectory((File)pConfig.getDbDirectory(), (File)new File(structureDirectory, "db"), (String)I18n._((String)"tutti.service.persistence.copyDirectory.db.error", (Object[])new Object[0]));
            TuttiIOUtil.copyDirectory((File)pConfig.getDbAttachmentDirectory(), (File)new File(structureDirectory, "meas_files"), (String)I18n._((String)"tutti.service.persistence.copyDirectory.attachment.error", (Object[])new Object[0]));
            TuttiIOUtil.zip((File)structureDirectory, (File)file, (String)I18n._((String)"tutti.service.persistence.exportDb.zip.error", (Object[])new Object[]{file}));
        }
        catch (Throwable throwable) {
            TuttiIOUtil.forceDeleteOnExit((File)structureDirectory, (String)I18n._((String)"tutti.service.persistence.exportDb.deleteTempDir.error", (Object[])new Object[]{structureDirectory}));
            throw throwable;
        }
        TuttiIOUtil.forceDeleteOnExit((File)structureDirectory, (String)I18n._((String)"tutti.service.persistence.exportDb.deleteTempDir.error", (Object[])new Object[]{structureDirectory}));
    }

    public ImportStructureType checkImportStructure(File file) {
        ImportStructureType result;
        if (!file.exists()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.persistence.checkImportstructure.fileNotExist", (Object[])new Object[]{file}));
        }
        FileObject fileObject = TuttiIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)I18n._((String)"tutti.service.persistence.getArchive.error", (Object[])new Object[]{file}));
        FileObject[] children = TuttiIOUtil.getChildren((FileObject)fileObject, (String)I18n._((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        if (children.length != 1) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.persistence.checkImportstructure.tooManyChildren", (Object[])new Object[]{file}));
        }
        fileObject = children[0];
        children = TuttiIOUtil.getChildren((FileObject)fileObject, (String)I18n._((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        boolean dbDirectoyDetected = false;
        for (FileObject child : children) {
            FileName name = child.getName();
            if (!name.getBaseName().equals("db")) continue;
            dbDirectoyDetected = true;
            break;
        }
        if (dbDirectoyDetected) {
            result = ImportStructureType.NORMAL;
            this.checkArchiveDb(file, fileObject, "db", true);
            this.checkArchiveDb(file, fileObject, "meas_files", false);
        } else {
            result = ImportStructureType.INLINE;
            for (FileObject child : children) {
                FileType type = TuttiIOUtil.getType((FileObject)child, (String)("Could not get type of " + child));
                if (!FileType.FOLDER.equals((Object)type)) continue;
                throw new TuttiBusinessException(I18n._((String)"tutti.service.persistence.checkImportstructure.inlineForbidDirectory", (Object[])new Object[0]));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Database import type: " + (Object)((Object)result)));
        }
        return result;
    }

    protected void checkArchiveDb(File file, FileObject fileObject, String dir, boolean required) {
        FileObject directory = TuttiIOUtil.getChild((FileObject)fileObject, (String)dir, (String)I18n._((String)"tutti.service.persistence.getChild.error", (Object[])new Object[]{dir}));
        if (directory == null) {
            String message = I18n._((String)"tutti.service.persistence.checkArchiveDb.error", (Object[])new Object[]{file, dir});
            if (required) {
                throw new TuttiBusinessException(message);
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
        }
    }

    public void importDb(ImportStructureType importStructureType, File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiServiceConfig config = this.context.getConfig();
        File target = config.getDataDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Import db to " + target));
        }
        FileObject fileObject = TuttiIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)I18n._((String)"tutti.service.persistence.getArchive.error", (Object[])new Object[]{file}));
        FileObject[] children = TuttiIOUtil.getChildren((FileObject)fileObject, (String)I18n._((String)"tutti.service.persistence.openArchive.error", (Object[])new Object[]{file}));
        fileObject = children[0];
        switch (importStructureType) {
            case NORMAL: {
                break;
            }
            case INLINE: {
                target = new File(target, "db");
                TuttiIOUtil.forceMkdir((File)target, (String)I18n._((String)"tutti.service.persistence.createDbDirectory.error", (Object[])new Object[]{file}));
            }
        }
        TuttiIOUtil.explode((FileObject)fileObject, (File)target, (FileSelector)new AllFileSelector(), (String)I18n._((String)"tutti.service.persistence.extractArchive.error", (Object[])new Object[]{file}));
    }

    public boolean isDbLoaded() {
        return !(this.driver instanceof TuttiPersistenceNoDbImpl);
    }

    public List<Caracteristic> getDefaultIndividualObservationCaracteristics() {
        ArrayList result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            List individualObservationPmfmId = this.getProtocol().getIndividualObservationPmfmId();
            if (CollectionUtils.isEmpty((Collection)individualObservationPmfmId)) {
                result = Lists.newArrayList();
            } else {
                result = Lists.newArrayListWithCapacity((int)individualObservationPmfmId.size());
                for (String id : individualObservationPmfmId) {
                    Caracteristic caracteristic = this.getCaracteristic(Integer.valueOf(id));
                    result.add(caracteristic);
                }
            }
        } else {
            result = Lists.newArrayList();
        }
        return result;
    }

    public List<Caracteristic> getLengthStepCaracteristics(List<Caracteristic> caracteristics) {
        List<Object> result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            result = Lists.newArrayListWithCapacity((int)protocol.sizeLengthClassesPmfmId());
            Map allCaractericsById = TuttiEntities.splitById(caracteristics);
            if (!protocol.isLengthClassesPmfmIdEmpty()) {
                for (String id : protocol.getLengthClassesPmfmId()) {
                    result.add(allCaractericsById.get(id));
                }
            }
        } else {
            result = Lists.newArrayList();
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    public List<Species> getReferentSpeciesWithSurveyCode(List<Species> referentSpecies) {
        List<Object> result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            result = Lists.newArrayList();
            if (!protocol.isSpeciesEmpty()) {
                Map map = TuttiEntities.splitByTaxonId(referentSpecies);
                for (SpeciesProtocol protocolSpecy : protocol.getSpecies()) {
                    String taxonId = String.valueOf(protocolSpecy.getSpeciesReferenceTaxonId());
                    Species species = (Species)map.get(taxonId);
                    species.setSurveyCode(protocolSpecy.getSpeciesSurveyCode());
                    result.add(species);
                }
            }
        } else {
            result = Lists.newArrayList(referentSpecies);
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    public List<Species> getReferentBenthosWithSurveyCode(List<Species> referentSpecies) {
        List<Object> result;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            result = Lists.newArrayList();
            if (!protocol.isBenthosEmpty()) {
                Map map = TuttiEntities.splitByTaxonId(referentSpecies);
                for (SpeciesProtocol protocolSpecy : protocol.getBenthos()) {
                    String taxonId = String.valueOf(protocolSpecy.getSpeciesReferenceTaxonId());
                    Species species = (Species)map.get(taxonId);
                    species.setSurveyCode(protocolSpecy.getSpeciesSurveyCode());
                    result.add(species);
                }
            }
        } else {
            result = Lists.newArrayList(referentSpecies);
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    public Map<Integer, SpeciesProtocol> toSpeciesProtocolMap() {
        TuttiProtocol protocol = this.getProtocol();
        Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
        HashMap result = Maps.newHashMap();
        for (SpeciesProtocol sp : protocol.getSpecies()) {
            result.put(sp.getSpeciesReferenceTaxonId(), sp);
        }
        return result;
    }

    public Map<Integer, SpeciesProtocol> toBenthosProtocolMap() {
        TuttiProtocol protocol = this.getProtocol();
        Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
        HashMap result = Maps.newHashMap();
        for (SpeciesProtocol sp : protocol.getBenthos()) {
            result.put(sp.getSpeciesReferenceTaxonId(), sp);
        }
        return result;
    }

    public SpeciesProtocol getSpeciesProtocol(Species species) {
        return this.getSpeciesProtocol(species, this.getProtocol().getSpecies());
    }

    public SpeciesProtocol getBenthosProtocol(Species species) {
        return this.getSpeciesProtocol(species, this.getProtocol().getBenthos());
    }

    public SpeciesProtocol getSpeciesProtocol(Species species, List<SpeciesProtocol> speciesProtocols) {
        for (SpeciesProtocol speciesProtocol : speciesProtocols) {
            if (!species.getReferenceTaxonId().equals(speciesProtocol.getSpeciesReferenceTaxonId())) continue;
            return speciesProtocol;
        }
        return null;
    }

    public void init() {
        long t0 = TimeLog.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opening persistence service...");
        }
        TuttiServiceConfig serviceConfig = this.context.getConfig();
        TuttiPersistenceConfig config = serviceConfig.getPersistenceConfig();
        TuttiPersistenceConfig.setInstance((TuttiPersistenceConfig)config);
        if (config.isDbExists()) {
            String jdbcUrl = config.getJdbcUrl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using database at " + jdbcUrl));
            }
            this.driver = TuttiPersistenceServiceLocator.getPersistenceService();
        } else {
            this.driver = new TuttiPersistenceNoDbImpl();
            this.driver.init();
        }
        TIME_LOG.log(t0, "Persistence driver *" + this.driver.getImplementationName() + "* opened.");
    }

    @Override
    public void close() throws IOException {
        long t0 = TimeLog.getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing persistence Service...");
        }
        IOUtils.closeQuietly((Closeable)this.driver);
        TIME_LOG.log(t0, "Persistence driver *" + this.driver.getImplementationName() + "* closed.");
    }

    public List<Vessel> getAllScientificVessel() {
        return this.driver.getAllScientificVessel();
    }

    public List<Vessel> getAllFishingVessel() {
        return this.driver.getAllFishingVessel();
    }

    public List<Species> getAllSpecies() {
        return this.driver.getAllSpecies();
    }

    public List<Species> getAllReferentSpecies() {
        return this.driver.getAllReferentSpecies();
    }

    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.driver.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    public List<Caracteristic> getAllCaracteristic() {
        return this.driver.getAllCaracteristic();
    }

    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.driver.getAllCaracteristicWithProtected();
    }

    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        return this.driver.getAllCaracteristicForSampleCategory();
    }

    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.driver.getAllNumericCaracteristic();
    }

    public List<TuttiLocation> getAllProgramZone() {
        return this.driver.getAllProgramZone();
    }

    public List<TuttiLocation> getAllCountry() {
        return this.driver.getAllCountry();
    }

    public List<TuttiLocation> getAllHarbour() {
        return this.driver.getAllHarbour();
    }

    public List<Gear> getAllScientificGear() {
        return this.driver.getAllScientificGear();
    }

    public List<Gear> getAllFishingGear() {
        return this.driver.getAllFishingGear();
    }

    public List<Person> getAllPerson() {
        return this.driver.getAllPerson();
    }

    public List<ObjectType> getAllObjectType() {
        return this.driver.getAllObjectType();
    }

    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.driver.getAllFishingOperationStrata(zoneId);
    }

    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.driver.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.driver.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    public Caracteristic getSizeCategoryCaracteristic() {
        return this.driver.getSizeCategoryCaracteristic();
    }

    public Caracteristic getSexCaracteristic() {
        return this.driver.getSexCaracteristic();
    }

    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.driver.getSortedUnsortedCaracteristic();
    }

    public Caracteristic getMaturityCaracteristic() {
        return this.driver.getMaturityCaracteristic();
    }

    public Caracteristic getAgeCaracteristic() {
        return this.driver.getAgeCaracteristic();
    }

    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.driver.getMarineLitterCategoryCaracteristic();
    }

    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.driver.getMarineLitterSizeCategoryCaracteristic();
    }

    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.driver.getVerticalOpeningCaracteristic();
    }

    public Caracteristic getHorizontalOpeningWingCaracteristic() {
        return this.driver.getHorizontalOpeningWingCaracteristic();
    }

    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.driver.getHorizontalOpeningDoorCaracteristic();
    }

    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.driver.getDeadOrAliveCaracteristic();
    }

    public Caracteristic getPmfmIdCaracteristic() {
        return this.driver.getPmfmIdCaracteristic();
    }

    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.driver.getWeightMeasuredCaracteristic();
    }

    public Caracteristic getCaracteristic(Integer pmfmId) {
        return this.driver.getCaracteristic(pmfmId);
    }

    public boolean isVracSpeciesBatch(SpeciesBatch speciesBatch) {
        return this.driver.isVracSpeciesBatch(speciesBatch);
    }

    public boolean isVracBenthosBatch(BenthosBatch benthosBatch) {
        return this.driver.isVracBenthosBatch(benthosBatch);
    }

    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.driver.isTemporary(entity);
    }

    public Vessel getVessel(String vesselCode) {
        return this.driver.getVessel(vesselCode);
    }

    public Person getPerson(Integer personId) {
        return this.driver.getPerson(personId);
    }

    public Gear getGear(Integer gearCode) {
        return this.driver.getGear(gearCode);
    }

    public ObjectType getObjectType(String objectTypeCode) {
        return this.driver.getObjectType(objectTypeCode);
    }

    public List<Species> importTemporarySpecies(List<Species> species) {
        return this.driver.importTemporarySpecies(species);
    }

    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        return this.driver.importTemporaryVessel(vessels);
    }

    public List<Person> importTemporaryPerson(List<Person> persons) {
        return this.driver.importTemporaryPerson(persons);
    }

    public List<Gear> importTemporaryGear(List<Gear> gears) {
        return this.driver.importTemporaryGear(gears);
    }

    public List<Attachment> getAllAttachments(AttachementObjectTypeEnum objectType, Integer objectId) {
        return this.driver.getAllAttachments(objectType, objectId);
    }

    public File getAttachmentFile(String attachmentId) {
        return this.driver.getAttachmentFile(attachmentId);
    }

    public Attachment createAttachment(Attachment attachment, File file) {
        return this.driver.createAttachment(attachment, file);
    }

    public Attachment saveAttachment(Attachment attachment) {
        return this.driver.saveAttachment(attachment);
    }

    public void deleteAttachment(String attachmentId) {
        this.driver.deleteAttachment(attachmentId);
    }

    public List<Program> getAllProgram() {
        return this.driver.getAllProgram();
    }

    public Program getProgram(String id) {
        return this.driver.getProgram(id);
    }

    public Program createProgram(Program bean) {
        return this.driver.createProgram(bean);
    }

    public Program saveProgram(Program bean) {
        return this.driver.saveProgram(bean);
    }

    public List<Cruise> getAllCruise(String programId) {
        return this.driver.getAllCruise(programId);
    }

    public Cruise getCruise(String id) {
        return this.driver.getCruise(id);
    }

    public Cruise createCruise(Cruise bean) {
        return this.driver.createCruise(bean);
    }

    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        return this.driver.saveCruise(bean, updateVessel, updateGear);
    }

    public CaracteristicMap getGearCaracteristics(String cruiseId, String gearId, short rankOrder) {
        return this.driver.getGearCaracteristics(cruiseId, gearId, rankOrder);
    }

    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        return this.driver.isOperationUseGears(cruiseId, gears);
    }

    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.driver.saveGearCaracteristics(gear, cruise);
    }

    public TuttiProtocol getProtocol() {
        return this.driver.getProtocol();
    }

    public void setProtocol(TuttiProtocol protocol) {
        this.driver.setProtocol(protocol);
    }

    public boolean isProtocolExist(String id) {
        return this.driver.isProtocolExist(id);
    }

    public List<String> getAllProtocolNames() {
        return this.driver.getAllProtocolNames();
    }

    public List<TuttiProtocol> getAllProtocol() {
        return this.driver.getAllProtocol();
    }

    public TuttiProtocol getProtocol(String id) {
        return this.driver.getProtocol(id);
    }

    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.driver.createProtocol(bean);
    }

    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.driver.saveProtocol(bean);
    }

    public void deleteProtocol(String id) {
        this.driver.deleteProtocol(id);
    }

    public int getFishingOperationCount(String cruiseId) {
        return this.driver.getFishingOperationCount(cruiseId);
    }

    public List<String> getAllFishingOperationIds(String cruiseId) {
        return this.driver.getAllFishingOperationIds(cruiseId);
    }

    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.driver.getAllFishingOperation(cruiseId);
    }

    public FishingOperation getFishingOperation(String id) {
        FishingOperation bean = this.driver.getFishingOperation(id);
        if (bean.getGearShootingEndDate() == null) {
            bean.setGearShootingEndDate(bean.getGearShootingStartDate());
        }
        return bean;
    }

    public List<Vessel> getFishingOperationSecondaryVessel(String fishingOperationId) {
        return this.driver.getFishingOperationSecondaryVessel(fishingOperationId);
    }

    public FishingOperation createFishingOperation(FishingOperation bean) {
        if (ObjectUtils.equals((Object)bean.getGearShootingStartDate(), (Object)bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.createFishingOperation(bean);
    }

    public FishingOperation saveFishingOperation(FishingOperation bean) {
        if (ObjectUtils.equals((Object)bean.getGearShootingStartDate(), (Object)bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.saveFishingOperation(bean);
    }

    public void deleteFishingOperation(String id) {
        this.driver.deleteFishingOperation(id);
    }

    public boolean isFishingOperationWithCatchBatch(String operationId) {
        return this.driver.isFishingOperationWithCatchBatch(operationId);
    }

    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.driver.getCatchBatchFromFishingOperation(id);
    }

    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.driver.createCatchBatch(bean);
    }

    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.driver.saveCatchBatch(bean);
    }

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, SampleCategoryModel sampleCategoryModel) {
        return this.driver.getRootSpeciesBatch(fishingOperationId, sampleCategoryModel);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.driver.createSpeciesBatch(bean, parentBatchId);
    }

    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.driver.saveSpeciesBatch(bean);
    }

    public void deleteSpeciesBatch(String id) {
        this.driver.deleteSpeciesBatch(id);
    }

    public void deleteSpeciesSubBatch(String id) {
        this.driver.deleteSpeciesSubBatch(id);
    }

    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.driver.changeSpeciesBatchSpecies(batchId, species);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.driver.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.driver.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId, SampleCategoryModel sampleCategoryModel) throws InvalidBatchModelException {
        return this.driver.getRootBenthosBatch(fishingOperationId, sampleCategoryModel);
    }

    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        return this.driver.createBenthosBatch(bean, parentBatchId);
    }

    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        return this.driver.saveBenthosBatch(bean);
    }

    public void deleteBenthosBatch(String id) {
        this.driver.deleteBenthosBatch(id);
    }

    public void deleteBenthosSubBatch(String id) {
        this.driver.deleteBenthosSubBatch(id);
    }

    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.driver.changeBenthosBatchSpecies(batchId, species);
    }

    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.driver.getAllBenthosBatchFrequency(benthosBatchId);
    }

    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        return this.driver.saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(String fishingOperationId) {
        return this.driver.getRootMarineLitterBatch(fishingOperationId);
    }

    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.driver.createMarineLitterBatch(bean);
    }

    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.driver.saveMarineLitterBatch(bean);
    }

    public void deleteMarineLitterBatch(String id) {
        this.driver.deleteMarineLitterBatch(id);
    }

    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.driver.getAllAccidentalBatch(fishingOperationId);
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.driver.createAccidentalBatch(bean);
    }

    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.driver.saveAccidentalBatch(bean);
    }

    public void deleteAccidentalBatch(String id) {
        this.driver.deleteAccidentalBatch(id);
    }

    public List<IndividualObservationBatch> getAllIndividualObservationBatch(String fishingOperationId) {
        return this.driver.getAllIndividualObservationBatch(fishingOperationId);
    }

    public IndividualObservationBatch createIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.driver.createIndividualObservationBatch(bean);
    }

    public IndividualObservationBatch saveIndividualObservationBatch(IndividualObservationBatch bean) {
        return this.driver.saveIndividualObservationBatch(bean);
    }

    public void deleteIndividualObservationBatch(String id) {
        this.driver.deleteIndividualObservationBatch(id);
    }

    public static enum ImportStructureType {
        NORMAL,
        INLINE;

    }

    public static interface FrequencyFunction<S extends SpeciesAbleBatch, F extends SpeciesAbleBatchFrequency>
    extends Function<S, List<F>> {
    }
}

