/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4.support;

import java.io.IOException;
import java.util.concurrent.Callable;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory = this.lookupSessionFactory(request);
        boolean participate = false;
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        String key = this.getAlreadyFilteredAttributeName();
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory)) {
            participate = true;
        } else {
            boolean isFirstRequest;
            boolean bl = isFirstRequest = !this.isAsyncDispatch(request);
            if (isFirstRequest || !this.applySessionBindingInterceptor(asyncManager, key)) {
                this.logger.debug((Object)"Opening Hibernate Session in OpenSessionInViewFilter");
                Session session = this.openSession(sessionFactory);
                SessionHolder sessionHolder = new SessionHolder(session);
                TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
                asyncManager.registerCallableInterceptor((Object)key, (CallableProcessingInterceptor)new SessionBindingCallableInterceptor(sessionFactory, sessionHolder));
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)sessionFactory));
                if (!this.isAsyncStarted(request)) {
                    this.logger.debug((Object)"Closing Hibernate Session in OpenSessionInViewFilter");
                    SessionFactoryUtils.closeSession(sessionHolder.getSession());
                }
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            Session session = sessionFactory.openSession();
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    private boolean applySessionBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((SessionBindingCallableInterceptor)asyncManager.getCallableInterceptor((Object)key)).initializeThread();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionBindingCallableInterceptor
    extends CallableProcessingInterceptorAdapter {
        private final SessionFactory sessionFactory;
        private final SessionHolder sessionHolder;

        public SessionBindingCallableInterceptor(SessionFactory sessionFactory, SessionHolder sessionHolder) {
            this.sessionFactory = sessionFactory;
            this.sessionHolder = sessionHolder;
        }

        public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
            this.initializeThread();
        }

        public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }

        private void initializeThread() {
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
        }
    }
}

