/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRow;
import java.util.List;
import java.util.Map;
import org.nuiton.util.csv.ValueFormatter;

public class IndividualObservationRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<IndividualObservationRow> {
    public IndividualObservationRowModel(char separator) {
        this(separator, null, null);
    }

    public IndividualObservationRowModel(char separator, List<Species> species, List<Caracteristic> lengthStepCaracteristics) {
        super(separator);
        this.newColumnForImportExport("batchId");
        this.newColumnForExport("species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species value) {
                return value != null ? String.valueOf(value.getReferenceTaxonId()) : null;
            }
        });
        if (species == null) {
            species = Lists.newArrayList();
        }
        Map speciesMap = TuttiEntities.splitByTaxonId((Iterable)species);
        this.newForeignKeyColumn("species", Species.class, "referenceTaxonId", speciesMap);
        this.newColumnForImportExport("weight", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("size", TuttiCsvUtil.FLOAT);
        this.newColumnForExport("lengthStepCaracteristic", (ValueFormatter)new ValueFormatter<Caracteristic>(){

            public String format(Caracteristic value) {
                return value != null ? value.getId() : "";
            }
        });
        if (lengthStepCaracteristics == null) {
            lengthStepCaracteristics = Lists.newArrayList();
        }
        ImmutableMap caracteristicMap = Maps.uniqueIndex((Iterable)lengthStepCaracteristics, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("lengthStepCaracteristic", Caracteristic.class, "id", caracteristicMap);
        this.newColumnForImportExport("samplingCode");
        this.newColumnForImportExport("calcifiedPieceSamplingCode");
        this.newColumnForImportExport("comment");
    }

    public IndividualObservationRow newEmptyInstance() {
        return new IndividualObservationRow();
    }
}

