/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRow;
import java.io.Serializable;
import java.util.List;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueParser;

public class CaracteristicRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<CaracteristicRow> {
    public CaracteristicRowModel(char separator) {
        this(separator, null);
    }

    public CaracteristicRowModel(char separator, List<Caracteristic> caracteristics) {
        super(separator);
        this.newColumnForImportExport("batchId");
        this.newColumnForExport("caracteristic", (ValueFormatter)new ValueFormatter<Caracteristic>(){

            public String format(Caracteristic value) {
                return value != null ? value.getId() : "";
            }
        });
        if (caracteristics == null) {
            caracteristics = Lists.newArrayList();
        }
        ImmutableMap caracteristicMap = Maps.uniqueIndex((Iterable)caracteristics, (Function)TuttiEntities.GET_ID);
        this.newForeignKeyColumn("caracteristic", Caracteristic.class, "id", caracteristicMap);
        this.newColumnForExport("value", (ValueFormatter)new ValueFormatter<Serializable>(){

            public String format(Serializable value) {
                String result = "";
                if (value != null) {
                    if (CaracteristicQualitativeValue.class.isAssignableFrom(value.getClass())) {
                        CaracteristicQualitativeValue cqv = (CaracteristicQualitativeValue)value;
                        result = cqv.getId();
                    } else {
                        result = String.valueOf(value);
                    }
                }
                return result;
            }
        });
        this.newMandatoryColumn("value", (ValueParser)TuttiCsvUtil.STRING);
    }

    public CaracteristicRow newEmptyInstance() {
        return new CaracteristicRow();
    }
}

