/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.andromda.utils.inflector.EnglishInflector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;

public class StringUtilsHelper
extends StringUtils {
    private static final Logger logger = Logger.getLogger((Class)(class$org$andromda$utils$StringUtilsHelper == null ? (class$org$andromda$utils$StringUtilsHelper = StringUtilsHelper.class$("org.andromda.utils.StringUtilsHelper")) : class$org$andromda$utils$StringUtilsHelper));
    private static final String LINE_SEPARATOR = "\n";
    static /* synthetic */ Class class$org$andromda$utils$StringUtilsHelper;

    public static String replaceSuffix(String src, String suffixOld, String suffixNew) {
        if (src.endsWith(suffixOld)) {
            return src.substring(0, src.length() - suffixOld.length()) + suffixNew;
        }
        return src;
    }

    public static String upperCamelCaseName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        String[] parts = StringUtilsHelper.splitAtNonWordCharacters(string);
        StringBuffer conversionBuffer = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() < 2) {
                conversionBuffer.append(parts[i].toUpperCase());
                continue;
            }
            conversionBuffer.append(parts[i].substring(0, 1).toUpperCase());
            conversionBuffer.append(parts[i].substring(1));
        }
        return conversionBuffer.toString();
    }

    public static String removeLastOccurrence(String string, String value) {
        if (string != null && value != null) {
            StringBuffer buf = new StringBuffer();
            int index = string.lastIndexOf(value);
            if (index != -1) {
                buf.append(string.substring(0, index));
                buf.append(string.substring(index + value.length(), string.length()));
                string = buf.toString();
            }
        }
        return string;
    }

    public static String lowerCamelCaseName(String string) {
        return StringUtils.uncapitalize((String)StringUtilsHelper.upperCamelCaseName(string));
    }

    public static String toResourceMessageKey(String string) {
        return StringUtilsHelper.separate(StringUtils.trimToEmpty((String)string), ".").toLowerCase();
    }

    public static String toPhrase(String string) {
        return StringUtils.capitalize((String)StringUtilsHelper.separate(string, " "));
    }

    public static String separate(String string, String separator) {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        String[] parts = StringUtilsHelper.splitAtNonWordCharacters(string);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (parts[i].trim().length() <= 0) continue;
            buffer.append(parts[i]).append(separator);
        }
        return buffer.append(parts[parts.length - 1]).toString();
    }

    private static String[] splitAtNonWordCharacters(String string) {
        Pattern capitalSequencePattern = Pattern.compile("[A-Z]+");
        Matcher matcher = capitalSequencePattern.matcher(StringUtils.trimToEmpty((String)string));
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, ' ' + matcher.group());
        }
        matcher.appendTail(buffer);
        return buffer.toString().split("[^A-Za-z0-9]+");
    }

    public static String suffixLines(String multiLines, String suffix) {
        String[] lines = StringUtils.trimToEmpty((String)multiLines).split(LINE_SEPARATOR);
        StringBuffer linesBuffer = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            linesBuffer.append(line);
            linesBuffer.append(suffix);
            linesBuffer.append(LINE_SEPARATOR);
        }
        return linesBuffer.toString();
    }

    public static String toResourceMessage(String multiLines) {
        String resourceMessage = null;
        if (StringUtils.isNotBlank((String)multiLines)) {
            String suffix = "\\";
            multiLines = StringUtilsHelper.suffixLines(multiLines, " \\").trim();
            while (multiLines.endsWith("\\")) {
                multiLines = multiLines.substring(0, multiLines.lastIndexOf("\\")).trim();
            }
            resourceMessage = multiLines;
        }
        return resourceMessage;
    }

    public static String prefixWithAPredicate(String word) {
        StringBuffer formattedBuffer = new StringBuffer();
        formattedBuffer.append("a ");
        formattedBuffer.append(word);
        char firstChar = word.charAt(0);
        switch (firstChar) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': {
                formattedBuffer.insert(1, 'n');
                break;
            }
        }
        return formattedBuffer.toString();
    }

    public static String toSingleLine(String string) {
        return string == null ? "" : string.replaceAll("[$\\s]+", " ").trim();
    }

    public static String pluralize(String singularNoun) {
        String plural = EnglishInflector.pluralize(singularNoun);
        return plural == null ? "" : plural.trim();
    }

    public static String format(String plainText) {
        return StringUtilsHelper.format(plainText, "");
    }

    public static String format(String plainText, String indentation) {
        return StringUtilsHelper.format(plainText, indentation, 64);
    }

    public static String format(String plainText, String indentation, int wrapAtColumn) {
        return StringUtilsHelper.format(plainText, indentation, wrapAtColumn, true);
    }

    public static String format(String plainText, String indentation, int wrapAtColumn, boolean htmlStyle) {
        String format;
        if (wrapAtColumn < 1) {
            throw new IllegalArgumentException("Cannot wrap at column less than 1: " + wrapAtColumn);
        }
        if (indentation == null) {
            indentation = "";
        }
        if (StringUtils.isBlank((String)plainText)) {
            return indentation;
        }
        String lineSeparator = LINE_SEPARATOR;
        try {
            StringBuffer formattedText = new StringBuffer();
            BufferedReader reader = new BufferedReader(new StringReader(plainText));
            String line = reader.readLine();
            while (line != null) {
                if (StringUtils.isNotBlank((String)line)) {
                    if (htmlStyle) {
                        formattedText.append(indentation);
                        formattedText.append("<p>");
                        formattedText.append(LINE_SEPARATOR);
                    }
                    formattedText.append(indentation);
                    formattedText.append(WordUtils.wrap((String)line.trim(), (int)wrapAtColumn, (String)(LINE_SEPARATOR + indentation), (boolean)false));
                    if (htmlStyle) {
                        formattedText.append(LINE_SEPARATOR);
                        formattedText.append(indentation);
                        formattedText.append("</p>");
                    }
                }
                line = reader.readLine();
                if (formattedText.length() <= 0 || !StringUtils.isNotBlank((String)line)) continue;
                formattedText.append(LINE_SEPARATOR);
            }
            reader.close();
            format = formattedText.toString();
        }
        catch (IOException ioException) {
            logger.error((Object)("Could not format text: " + plainText), (Throwable)ioException);
            format = plainText;
        }
        return format;
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

