/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public abstract class TuttiTableMetadata {
    protected static final String QUERY_SELECT_MAX_UPDATE = "SELECT max(update_date) FROM %s";
    protected static final String QUERY_INSERT = "INSERT INTO %s (%s) VALUES (%s)";
    protected static final String QUERY_UPDATE = "UPDATE %s SET %s WHERE %s";
    protected static final String QUERY_SELECT_PRIMARY_KEYS = "SELECT %s FROM %s";
    protected static final String QUERY_SELECT_COUNT = "SELECT count(*) FROM %s";
    protected final String existingPrimaryKeysQuery;
    private final String maxUpdateDateQuery;
    protected final String countQuery;
    protected final TableMetadata delegate;
    protected final Map<String, ColumnMetadata> columns;
    protected final Set<String> pkNames;
    protected final int[] pkIndexs;
    protected final String insertQuery;
    protected final String updateQuery;
    protected final boolean withUpdateDateColumn;

    public abstract String getCountDataToUpdateQueryWithNull();

    public abstract String getDataToUpdateQueryWithNull();

    public abstract String getCountDataToUpdateQuery();

    public abstract String getDataToUpdateQuery();

    public abstract boolean useUpdateDateColumn();

    public TuttiTableMetadata(TableMetadata delegate, DatabaseMetaData meta) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
        try {
            Field field = TableMetadata.class.getDeclaredField("columns");
            field.setAccessible(true);
            this.columns = (Map)field.get(delegate);
            this.withUpdateDateColumn = this.columns.containsKey("update_date");
            this.pkNames = this.initPrimaryKeys(meta);
            Preconditions.checkNotNull(this.pkNames);
            this.pkIndexs = this.createPkIndex();
            this.insertQuery = this.createInsertQuery();
            this.updateQuery = this.createUpdateQuery();
            this.maxUpdateDateQuery = String.format(QUERY_SELECT_MAX_UPDATE, this.getName());
            this.existingPrimaryKeysQuery = String.format(QUERY_SELECT_PRIMARY_KEYS, Joiner.on((char)',').join(this.pkNames), this.getName());
            this.countQuery = String.format(QUERY_SELECT_COUNT, this.getName());
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.persistence.tableMetadata.instanciation.error", (Object[])new Object[]{this}), e);
        }
    }

    public Set<String> getPkNames() {
        return this.pkNames;
    }

    public boolean isWithUpdateDateColumn() {
        return this.withUpdateDateColumn;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public SortedSet<String> getColumnNames() {
        return Sets.newTreeSet(this.columns.keySet());
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(ForeignKey fk) {
        return this.delegate.getForeignKeyMetadata(fk);
    }

    public ColumnMetadata getColumnMetadata(String columnName) {
        return this.delegate.getColumnMetadata(columnName);
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getCatalog() {
        return this.delegate.getCatalog();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return this.delegate.getForeignKeyMetadata(keyName);
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return this.delegate.getIndexMetadata(indexName);
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public String getUpdateQuery() {
        return this.updateQuery;
    }

    public String getExistingPrimaryKeysQuery() {
        return this.existingPrimaryKeysQuery;
    }

    public String getMaxUpdateDateQuery() {
        return this.maxUpdateDateQuery;
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public int[] getPkIndexs() {
        return this.pkIndexs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initPrimaryKeys(DatabaseMetaData meta) throws SQLException {
        HashSet result = Sets.newHashSet();
        ResultSet rs = meta.getPrimaryKeys(this.getCatalog(), this.getSchema(), this.getName());
        try {
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)result);
            return immutableSet;
        }
        finally {
            TuttiEntities.closeSilently(rs);
        }
    }

    protected int[] createPkIndex() {
        int[] result = new int[this.pkNames.size()];
        int pkI = 0;
        for (String pkName : this.pkNames) {
            String pkColumnName = pkName.toLowerCase();
            int i = 1;
            int index = -1;
            for (String columnName : this.getColumnNames()) {
                if (pkColumnName.equals(columnName)) {
                    index = i;
                    continue;
                }
                ++i;
            }
            result[pkI++] = index;
        }
        return result;
    }

    protected String createInsertQuery() {
        StringBuilder queryParams = new StringBuilder();
        StringBuilder valueParams = new StringBuilder();
        for (String columnName : this.getColumnNames()) {
            queryParams.append(", ").append(columnName);
            valueParams.append(", ?");
        }
        String result = String.format(QUERY_INSERT, this.getName(), queryParams.substring(2), valueParams.substring(2));
        return result;
    }

    protected String createUpdateQuery() {
        StringBuilder updateParams = new StringBuilder();
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.getColumnNames()) {
            updateParams.append(", ").append(columnName).append(" = ?");
        }
        for (String columnName : this.getPkNames()) {
            pkParams.append("AND ").append(columnName).append(" = ?");
        }
        String result = String.format(QUERY_UPDATE, this.getName(), updateParams.substring(2), pkParams.substring(4));
        return result;
    }
}

