/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate.metafacades;

import org.andromda.cartridges.hibernate.HibernateProfile;
import org.andromda.cartridges.hibernate.HibernateUtils;
import org.andromda.cartridges.hibernate.metafacades.HibernateEmbeddedValue;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntity;
import org.andromda.cartridges.hibernate.metafacades.HibernateEntityAttributeLogic;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EntityMetafacadeUtils;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.TypeMappings;
import org.apache.commons.lang.StringUtils;

public class HibernateEntityAttributeLogicImpl
extends HibernateEntityAttributeLogic {
    public HibernateEntityAttributeLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    public boolean isRequired() {
        HibernateEntity entity;
        boolean required = super.isRequired();
        if (this.getOwner() instanceof HibernateEntity && (entity = (HibernateEntity)this.getOwner()).isHibernateInheritanceClass() && entity.getGeneralization() != null) {
            required = false;
        }
        return required;
    }

    public String getDefaultValue() {
        String defaultValue = super.getDefaultValue();
        ClassifierFacade type = this.getType();
        if (type != null) {
            String fullyQualifiedName = StringUtils.trimToEmpty((String)type.getFullyQualifiedName());
            if ("java.lang.String".equals(fullyQualifiedName)) {
                defaultValue = "\"" + defaultValue + "\"";
            } else if (fullyQualifiedName.startsWith("java.lang")) {
                defaultValue = fullyQualifiedName + ".valueOf(" + defaultValue + ")";
            } else if (type.isEnumeration()) {
                String mask = (String)this.getConfiguredProperty("enumerationLiteralNameMask");
                defaultValue = type.getFullyQualifiedName() + '.' + NameMasker.mask((String)defaultValue, (String)mask);
            }
        }
        return defaultValue;
    }

    protected boolean handleIsContainsEmbeddedObject() {
        boolean returnValue = false;
        if (this.getType() instanceof HibernateEmbeddedValue) {
            returnValue = true;
        }
        return returnValue;
    }

    protected String handleConcatColumnName(String prefix, String name) {
        String returnValue = name;
        if (StringUtils.isNotBlank((String)prefix)) {
            returnValue = prefix + this.getConfiguredProperty("sqlNameSeparator") + name;
            Short maxSqlNameLength = Short.valueOf((String)this.getConfiguredProperty("maxSqlNameLength"));
            returnValue = EntityMetafacadeUtils.ensureMaximumNameLength((String)returnValue, (Short)maxSqlNameLength);
        }
        return returnValue;
    }

    protected boolean handleIsLazy() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_LAZY);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : false;
    }

    protected String handleGetFormula() {
        return (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_FORMULA);
    }

    protected boolean handleIsInsertEnabled() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROPERTY_INSERT);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : true;
    }

    protected boolean handleIsUpdateEnabled() {
        String value = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_PROPERTY_UPDATE);
        return StringUtils.isNotBlank((String)value) ? Boolean.valueOf(value) : true;
    }

    private boolean isXmlPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive((String)this.getConfiguredProperty("hibernateVersion"), (String)this.getConfiguredProperty("hibernateXMLPersistence"));
    }

    private boolean persistIDAsAttribute() {
        boolean persistAsAttribute = true;
        String prop = (String)this.getConfiguredProperty("hibernateXMLPersistIDAsAttribute");
        if (prop != null && prop.equalsIgnoreCase("false")) {
            persistAsAttribute = false;
        }
        return persistAsAttribute;
    }

    protected String handleGetXmlTagName() {
        String tagName = null;
        if (this.isXmlPersistenceActive() && (tagName = (String)this.findTaggedValue(HibernateProfile.TAGGEDVALUE_HIBERNATE_XML_TAG_NAME)) == null) {
            tagName = this.isIdentifier() && this.persistIDAsAttribute() ? "@" + this.getName() : this.getName();
        }
        return StringUtils.isBlank(tagName) ? null : tagName;
    }

    protected String handleGetFullyQualifiedHibernateType() {
        String fullyQualifiedName;
        if (this.getType().isEnumeration()) {
            fullyQualifiedName = "org.andromda.persistence.hibernate.usertypes.HibernateEnumType";
        } else {
            String hibernateTypeMappingsUri = (String)this.getConfiguredProperty("hibernateTypeMappingsUri");
            TypeMappings mappings = TypeMappings.getInstance((String)hibernateTypeMappingsUri);
            if (mappings == null) {
                fullyQualifiedName = this.getType().getFullyQualifiedName();
            } else {
                String fullyQualifiedModelName = this.getType().getFullyQualifiedName(true);
                fullyQualifiedName = mappings.getMappings().containsFrom(fullyQualifiedModelName) ? mappings.getTo(fullyQualifiedModelName) : this.getType().getFullyQualifiedName();
            }
        }
        return fullyQualifiedName;
    }

    protected String handleGetComments() {
        return HibernateUtils.convertDocumentationIntoComments(this.getDocumentation(""));
    }

    protected boolean handleIsNaturalId() {
        return this.hasStereotype(HibernateProfile.STEREOTYPE_NATURALID);
    }
}

