/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DeleteFishingOperationAction
extends AbstractTuttiAction<FishingOperationsUIModel, FishingOperationsUI, FishingOperationsUIHandler> {
    private static final Log log = LogFactory.getLog(DeleteFishingOperationAction.class);

    public DeleteFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.editFishingOperation.action.deleteFishingOperation.tip", (Object[])new Object[0]));
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        FishingOperation fishingOperation = ((FishingOperationsUIModel)((Object)this.getModel())).getSelectedFishingOperation();
        return canContinue &= fishingOperation != null && !TuttiEntities.isNew(fishingOperation) && ((FishingOperationsUIHandler)this.getHandler()).askBeforeDelete(I18n._((String)"tutti.editFishingOperation.action.deleteFishingOperation.title", (Object[])new Object[0]), I18n._((String)"tutti.editFishingOperation.action.deleteFishingOperation.message", (Object[])new Object[]{this.decorate(fishingOperation)}));
    }

    @Override
    protected void doAction() throws Exception {
        FishingOperation fishingOperation = ((FishingOperationsUIModel)((Object)this.getModel())).getSelectedFishingOperation();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete fishingOperation: " + fishingOperation));
        }
        this.getContext().getPersistenceService().deleteFishingOperation(fishingOperation.getId());
        FishingOperationsUIModel model = (FishingOperationsUIModel)((Object)this.getModel());
        model.setSelectedFishingOperation(null);
        model.removeFishingOperation(fishingOperation);
        this.sendMessage(I18n._((String)"tutti.editFishingOperation.message.operation.deleted", (Object[])new Object[]{this.decorate(fishingOperation)}));
    }
}

