/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactoryException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlObjectFactory {
    protected static final Logger logger = Logger.getLogger((Class)(class$org$andromda$core$common$XmlObjectFactory == null ? (class$org$andromda$core$common$XmlObjectFactory = XmlObjectFactory.class$("org.andromda.core.common.XmlObjectFactory")) : class$org$andromda$core$common$XmlObjectFactory));
    private static final String RULES_SUFFIX = "-Rules.xml";
    private static final String SCHEMA_SUFFIX = ".xsd";
    private Digester digester = null;
    private Class objectClass = null;
    private URL objectRulesXml = null;
    private URL schemaUri = null;
    private static boolean defaultValidating = true;
    private static final Map factoryCache = new HashMap();
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SYSTEM_ID_FILE = "file:";
    static /* synthetic */ Class class$org$andromda$core$common$XmlObjectFactory;

    private XmlObjectFactory(URL objectRulesXml) {
        ExceptionUtils.checkNull("objectRulesXml", objectRulesXml);
        this.digester = DigesterLoader.createDigester((URL)objectRulesXml);
        this.digester.setUseContextClassLoader(true);
    }

    public static XmlObjectFactory getInstance(Class objectClass) {
        ExceptionUtils.checkNull("objectClass", objectClass);
        XmlObjectFactory factory = (XmlObjectFactory)factoryCache.get(objectClass);
        if (factory == null) {
            URL objectRulesXml = (class$org$andromda$core$common$XmlObjectFactory == null ? (class$org$andromda$core$common$XmlObjectFactory = XmlObjectFactory.class$("org.andromda.core.common.XmlObjectFactory")) : class$org$andromda$core$common$XmlObjectFactory).getResource('/' + objectClass.getName().replace('.', '/') + RULES_SUFFIX);
            if (objectRulesXml == null) {
                throw new XmlObjectFactoryException("No configuration rules found for class --> '" + objectClass + "'");
            }
            factory = new XmlObjectFactory(objectRulesXml);
            factory.objectClass = objectClass;
            factory.objectRulesXml = objectRulesXml;
            factory.setValidating(defaultValidating);
            factoryCache.put(objectClass, factory);
        }
        return factory;
    }

    public static void setDefaultValidating(boolean validating) {
        defaultValidating = validating;
    }

    public void setValidating(boolean validating) {
        this.digester.setValidating(validating);
        if (validating) {
            if (this.schemaUri == null) {
                String schemaLocation = '/' + this.objectClass.getName().replace('.', '/') + SCHEMA_SUFFIX;
                this.schemaUri = (class$org$andromda$core$common$XmlObjectFactory == null ? (class$org$andromda$core$common$XmlObjectFactory = XmlObjectFactory.class$("org.andromda.core.common.XmlObjectFactory")) : class$org$andromda$core$common$XmlObjectFactory).getResource(schemaLocation);
                try {
                    if (this.schemaUri != null) {
                        InputStream stream = this.schemaUri.openStream();
                        stream.close();
                        stream = null;
                    }
                }
                catch (IOException exception) {
                    this.schemaUri = null;
                }
                if (this.schemaUri == null) {
                    logger.warn((Object)("WARNING! Was not able to find schemaUri --> '" + schemaLocation + "' continuing in non validating mode"));
                }
            }
            if (this.schemaUri != null) {
                try {
                    this.digester.setSchema(this.schemaUri.toString());
                    this.digester.setErrorHandler((ErrorHandler)new XmlObjectValidator());
                    this.digester.setProperty(this.JAXP_SCHEMA_LANGUAGE, (Object)this.digester.getSchemaLanguage());
                    this.digester.setProperty(JAXP_SCHEMA_SOURCE, (Object)this.digester.getSchema());
                }
                catch (Exception exception) {
                    logger.warn((Object)"WARNING! Your parser does NOT support the  schema validation continuing in non validation mode", (Throwable)exception);
                }
            }
        }
    }

    public Object getObject(URL objectXml) {
        return this.getObject(objectXml != null ? ResourceUtils.getContents(objectXml) : null, objectXml);
    }

    public Object getObject(Reader objectXml) {
        return this.getObject(ResourceUtils.getContents(objectXml));
    }

    public Object getObject(String objectXml) {
        return this.getObject(objectXml, null);
    }

    public Object getObject(String objectXml, URL resource) {
        ExceptionUtils.checkNull("objectXml", objectXml);
        Object object = null;
        try {
            this.digester.setEntityResolver((EntityResolver)new XmlObjectEntityResolver(resource));
            object = this.digester.parse((Reader)new StringReader(objectXml));
            objectXml = null;
            if (object == null) {
                String message = "Was not able to instantiate an object using objectRulesXml '" + this.objectRulesXml + "' with objectXml '" + objectXml + "', please check either the objectXml " + "or objectRulesXml file for inconsistencies";
                throw new XmlObjectFactoryException(message);
            }
        }
        catch (SAXException exception) {
            Throwable cause = ExceptionUtils.getRootCause(exception);
            if (cause instanceof SAXException) {
                String message = "VALIDATION FAILED for --> '" + objectXml + "' against SCHEMA --> '" + this.schemaUri + "' --> message: '" + exception.getMessage() + "'";
                throw new XmlObjectFactoryException(message);
            }
            throw new XmlObjectFactoryException(cause);
        }
        catch (Throwable throwable) {
            String message = "XML resource could not be loaded --> '" + objectXml + "'";
            throw new XmlObjectFactoryException(message, throwable);
        }
        return object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class XmlObjectEntityResolver
    implements EntityResolver {
        private URL xmlResource;

        XmlObjectEntityResolver(URL xmlResource) {
            this.xmlResource = xmlResource;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String path;
            InputSource source = null;
            if (this.xmlResource != null && (path = systemId) != null && path.startsWith(XmlObjectFactory.SYSTEM_ID_FILE)) {
                String xmlResource = this.xmlResource.toString();
                path = path.replaceFirst(XmlObjectFactory.SYSTEM_ID_FILE, "");
                if ((path = ResourceUtils.normalizePath(path)).startsWith("/")) {
                    path = path.substring(1, path.length());
                }
                String xmlResourceName = xmlResource.replaceAll(".*(\\+|/)", "");
                URL uri = null;
                InputStream inputStream = null;
                try {
                    uri = ResourceUtils.toURL(StringUtils.replace((String)xmlResource, (String)xmlResourceName, (String)path));
                    if (uri != null) {
                        inputStream = uri.openStream();
                    }
                }
                catch (IOException exception) {
                    // empty catch block
                }
                if (inputStream == null) {
                    try {
                        uri = ResourceUtils.getResource(path);
                        if (uri != null) {
                            inputStream = uri.openStream();
                        }
                    }
                    catch (IOException exception) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    source = new InputSource(inputStream);
                    source.setPublicId(publicId);
                    source.setSystemId(uri.toString());
                }
            }
            return source;
        }
    }

    static final class XmlObjectValidator
    implements ErrorHandler {
        XmlObjectValidator() {
        }

        public final void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.getMessage(exception));
        }

        public final void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.getMessage(exception));
        }

        public final void warning(SAXParseException exception) {
            logger.warn((Object)("WARNING!: " + this.getMessage(exception)));
        }

        private String getMessage(SAXParseException exception) {
            StringBuffer message = new StringBuffer();
            if (exception != null) {
                message.append(exception.getMessage());
                message.append(", line: ");
                message.append(exception.getLineNumber());
                message.append(", column: ").append(exception.getColumnNumber());
            }
            return message.toString();
        }
    }
}

