/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class XAThreadPool {
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public synchronized MultiRunner getMultiRunner() {
        MultiRunner multiRunner = new MultiRunner();
        this.executor.submit(multiRunner);
        return multiRunner;
    }

    public synchronized void shutdown() {
        this.executor.shutdown();
    }

    public static final class MultiRunner
    implements Runnable {
        private CyclicBarrier startBarrier = new CyclicBarrier(2);
        private CyclicBarrier endBarrier = new CyclicBarrier(2);
        private volatile Callable callable;
        private volatile boolean released;
        private volatile Object result;

        private MultiRunner() {
        }

        public Object execute(Callable callable) throws ExecutionException, InterruptedException {
            if (this.released) {
                throw new IllegalStateException("MultiRunner has been released");
            }
            if (callable == null) {
                throw new NullPointerException("callable cannot be null");
            }
            try {
                this.callable = callable;
                this.startBarrier.await();
                this.endBarrier.await();
                return this.result;
            }
            catch (BrokenBarrierException e) {
                throw new ExecutionException("error executing " + callable, e);
            }
        }

        public void release() {
            try {
                this.callable = null;
                this.released = true;
                this.startBarrier.await();
            }
            catch (InterruptedException e) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }

        public void run() {
            try {
                while (true) {
                    this.startBarrier.await();
                    if (this.callable == null) break;
                    this.result = this.callable.call();
                    this.endBarrier.await();
                }
                return;
            }
            catch (Exception e) {
                this.released = true;
                e.printStackTrace();
                return;
            }
        }
    }
}

