/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.Citation;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameHistory;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameHistoryDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameHistoryImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class TaxonNameHistoryDaoBase
extends HibernateDaoSupport
implements TaxonNameHistoryDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonNameHistory.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(TaxonNameHistoryImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonNameHistory)entity);
    }

    @Override
    public TaxonNameHistory load(Integer id) {
        return (TaxonNameHistory)this.load(0, id);
    }

    @Override
    public Collection<TaxonNameHistory> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonNameHistoryImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonNameHistory create(TaxonNameHistory taxonNameHistory) {
        return (TaxonNameHistory)this.create(0, taxonNameHistory);
    }

    @Override
    public Object create(int transform, TaxonNameHistory taxonNameHistory) {
        if (taxonNameHistory == null) {
            throw new IllegalArgumentException("TaxonNameHistory.create - 'taxonNameHistory' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonNameHistory);
        return this.transformEntity(transform, taxonNameHistory);
    }

    @Override
    public Collection<TaxonNameHistory> create(Collection<TaxonNameHistory> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonNameHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonNameHistory.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonNameHistoryDaoBase.this.create(transform, (TaxonNameHistory)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonNameHistory create(String name, String comments, Integer upperRank, Boolean isReferent, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Timestamp updateDate, TaxonName parentTaxonName, TaxonName taxonName, Citation citation) {
        return (TaxonNameHistory)this.create(0, name, comments, upperRank, isReferent, isVirtual, isObsolete, isTemporary, updateDate, parentTaxonName, taxonName, citation);
    }

    @Override
    public Object create(int transform, String name, String comments, Integer upperRank, Boolean isReferent, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Timestamp updateDate, TaxonName parentTaxonName, TaxonName taxonName, Citation citation) {
        TaxonNameHistoryImpl entity = new TaxonNameHistoryImpl();
        entity.setName(name);
        entity.setComments(comments);
        entity.setUpperRank(upperRank);
        entity.setIsReferent(isReferent);
        entity.setIsVirtual(isVirtual);
        entity.setIsObsolete(isObsolete);
        entity.setIsTemporary(isTemporary);
        entity.setUpdateDate(updateDate);
        entity.setParentTaxonName(parentTaxonName);
        entity.setTaxonName(taxonName);
        entity.setCitation(citation);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonNameHistory taxonNameHistory) {
        if (taxonNameHistory == null) {
            throw new IllegalArgumentException("TaxonNameHistory.update - 'taxonNameHistory' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonNameHistory);
    }

    @Override
    public void update(final Collection<TaxonNameHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonNameHistory.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonNameHistoryDaoBase.this.update((TaxonNameHistory)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonNameHistory taxonNameHistory) {
        if (taxonNameHistory == null) {
            throw new IllegalArgumentException("TaxonNameHistory.remove - 'taxonNameHistory' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonNameHistory);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("TaxonNameHistory.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        TaxonNameHistory entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonNameHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonNameHistory.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonNameHistory entity) {
        TaxonNameHistory target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonNameHistory toEntity(Object[] row) {
        TaxonNameHistory target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonNameHistory)) continue;
                target = (TaxonNameHistory)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonNameHistoryImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonNameHistoryImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonNameHistory> search(Search search) {
        return this.search(0, search);
    }
}

