/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevel;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class LocationLevelDaoBase
extends HibernateDaoSupport
implements LocationLevelDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationLevel.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(LocationLevelImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationLevel)entity);
    }

    @Override
    public LocationLevel load(Integer id) {
        return (LocationLevel)this.load(0, id);
    }

    @Override
    public Collection<LocationLevel> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationLevelImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationLevel create(LocationLevel locationLevel) {
        return (LocationLevel)this.create(0, locationLevel);
    }

    @Override
    public Object create(int transform, LocationLevel locationLevel) {
        if (locationLevel == null) {
            throw new IllegalArgumentException("LocationLevel.create - 'locationLevel' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationLevel);
        return this.transformEntity(transform, locationLevel);
    }

    @Override
    public Collection<LocationLevel> create(Collection<LocationLevel> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLevel.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationLevelDaoBase.this.create(transform, (LocationLevel)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationLevel create(String name, Timestamp updateDate, LocationClassification locationClassification, Collection<LocationLevel> locationLevels, LocationLevel parentLocationLevel) {
        return (LocationLevel)this.create(0, name, updateDate, locationClassification, locationLevels, parentLocationLevel);
    }

    @Override
    public Object create(int transform, String name, Timestamp updateDate, LocationClassification locationClassification, Collection<LocationLevel> locationLevels, LocationLevel parentLocationLevel) {
        LocationLevelImpl entity = new LocationLevelImpl();
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setLocationClassification(locationClassification);
        entity.setLocationLevels(locationLevels);
        entity.setParentLocationLevel(parentLocationLevel);
        return this.create(transform, entity);
    }

    @Override
    public LocationLevel create(LocationClassification locationClassification, String name) {
        return (LocationLevel)this.create(0, locationClassification, name);
    }

    @Override
    public Object create(int transform, LocationClassification locationClassification, String name) {
        LocationLevelImpl entity = new LocationLevelImpl();
        entity.setLocationClassification(locationClassification);
        entity.setName(name);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationLevel locationLevel) {
        if (locationLevel == null) {
            throw new IllegalArgumentException("LocationLevel.update - 'locationLevel' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationLevel);
    }

    @Override
    public void update(final Collection<LocationLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLevel.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationLevelDaoBase.this.update((LocationLevel)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationLevel locationLevel) {
        if (locationLevel == null) {
            throw new IllegalArgumentException("LocationLevel.remove - 'locationLevel' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationLevel);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationLevel.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        LocationLevel entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationLevel> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLevel.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LocationLevel entity) {
        LocationLevel target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationLevel toEntity(Object[] row) {
        LocationLevel target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationLevel)) continue;
                target = (LocationLevel)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationLevelImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationLevelImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationLevel> search(Search search) {
        return this.search(0, search);
    }
}

