/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.gear;

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGear;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearDaoBase;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearExtendDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationImpl;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="fishingGearDao")
@Lazy
public class FishingGearDaoImpl
extends FishingGearDaoBase
implements FishingGearExtendDao {
    @Autowired
    public FishingGearDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public FishingGear createAsTemporary(String label, String name, Integer gearClassificationId) {
        Session session = this.getSession(false);
        Integer gearId = (Integer)TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, GearImpl.class);
        FishingGear target = FishingGear.Factory.newInstance();
        target.setId(gearId);
        target.setLabel(label);
        target.setName(name);
        target.setGearClassification((GearClassification)session.load(GearClassificationImpl.class, (Serializable)gearClassificationId));
        target.setStatus((Status)session.load(StatusImpl.class, (Serializable)((Object)StatusCode.TEMPORARY.getValue())));
        target = this.create(target);
        return target;
    }
}

