/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.data.history.ProcessingHistory;
import fr.ifremer.adagio.core.dao.referential.ProcessingStatus;
import fr.ifremer.adagio.core.dao.referential.ProcessingStatusDao;
import fr.ifremer.adagio.core.dao.referential.ProcessingStatusImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class ProcessingStatusDaoBase
extends HibernateDaoSupport
implements ProcessingStatusDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("ProcessingStatus.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(ProcessingStatusImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (ProcessingStatus)entity);
    }

    @Override
    public ProcessingStatus load(String code) {
        return (ProcessingStatus)this.load(0, code);
    }

    @Override
    public Collection<ProcessingStatus> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ProcessingStatusImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public ProcessingStatus create(ProcessingStatus processingStatus) {
        return (ProcessingStatus)this.create(0, processingStatus);
    }

    @Override
    public Object create(int transform, ProcessingStatus processingStatus) {
        if (processingStatus == null) {
            throw new IllegalArgumentException("ProcessingStatus.create - 'processingStatus' can not be null");
        }
        this.getHibernateTemplate().save((Object)processingStatus);
        return this.transformEntity(transform, processingStatus);
    }

    @Override
    public Collection<ProcessingStatus> create(Collection<ProcessingStatus> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<ProcessingStatus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingStatus.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProcessingStatusDaoBase.this.create(transform, (ProcessingStatus)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public ProcessingStatus create(String code, String name, Timestamp updateDate, Status status, Collection<ProcessingHistory> processingHistories) {
        return (ProcessingStatus)this.create(0, code, name, updateDate, status, processingHistories);
    }

    @Override
    public Object create(int transform, String code, String name, Timestamp updateDate, Status status, Collection<ProcessingHistory> processingHistories) {
        ProcessingStatusImpl entity = new ProcessingStatusImpl();
        entity.setCode(code);
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setProcessingHistories(processingHistories);
        return this.create(transform, entity);
    }

    @Override
    public ProcessingStatus create(String code, String name, Status status) {
        return (ProcessingStatus)this.create(0, code, name, status);
    }

    @Override
    public Object create(int transform, String code, String name, Status status) {
        ProcessingStatusImpl entity = new ProcessingStatusImpl();
        entity.setCode(code);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(ProcessingStatus processingStatus) {
        if (processingStatus == null) {
            throw new IllegalArgumentException("ProcessingStatus.update - 'processingStatus' can not be null");
        }
        this.getHibernateTemplate().update((Object)processingStatus);
    }

    @Override
    public void update(final Collection<ProcessingStatus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingStatus.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProcessingStatusDaoBase.this.update((ProcessingStatus)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(ProcessingStatus processingStatus) {
        if (processingStatus == null) {
            throw new IllegalArgumentException("ProcessingStatus.remove - 'processingStatus' can not be null");
        }
        this.getHibernateTemplate().delete((Object)processingStatus);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("ProcessingStatus.remove - 'code' can not be null");
        }
        String entityPk = code;
        ProcessingStatus entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<ProcessingStatus> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingStatus.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, ProcessingStatus entity) {
        ProcessingStatus target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected ProcessingStatus toEntity(Object[] row) {
        ProcessingStatus target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof ProcessingStatus)) continue;
                target = (ProcessingStatus)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProcessingStatusImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProcessingStatusImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<ProcessingStatus> search(Search search) {
        return this.search(0, search);
    }
}

