/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.survey.sale;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOrigin;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOriginDao;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOriginImpl;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOriginPK;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class SaleOriginDaoBase
extends HibernateDaoSupport
implements SaleOriginDao {
    @Override
    public Object load(int transform, Program program, Sale sale) {
        SaleOriginPK entityPk = new SaleOriginPK();
        if (program == null) {
            throw new IllegalArgumentException("SaleOrigin.load - 'program' can not be null");
        }
        if (sale == null) {
            throw new IllegalArgumentException("SaleOrigin.load - 'sale' can not be null");
        }
        entityPk.setProgram(program);
        entityPk.setSale(sale);
        Object entity = this.getHibernateTemplate().get(SaleOriginImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (SaleOrigin)entity);
    }

    @Override
    public SaleOrigin load(Program program, Sale sale) {
        return (SaleOrigin)this.load(0, program, sale);
    }

    @Override
    public Collection<SaleOrigin> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(SaleOriginImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public SaleOrigin create(SaleOrigin saleOrigin) {
        return (SaleOrigin)this.create(0, saleOrigin);
    }

    @Override
    public Object create(int transform, SaleOrigin saleOrigin) {
        if (saleOrigin == null) {
            throw new IllegalArgumentException("SaleOrigin.create - 'saleOrigin' can not be null");
        }
        this.getHibernateTemplate().save((Object)saleOrigin);
        return this.transformEntity(transform, saleOrigin);
    }

    @Override
    public Collection<SaleOrigin> create(Collection<SaleOrigin> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<SaleOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("SaleOrigin.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SaleOriginDaoBase.this.create(transform, (SaleOrigin)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public SaleOrigin create(Program program, Sale sale) {
        return (SaleOrigin)this.create(0, program, sale);
    }

    @Override
    public Object create(int transform, Program program, Sale sale) {
        SaleOriginImpl entity = new SaleOriginImpl();
        SaleOriginPK entityPk = new SaleOriginPK();
        entity.setSaleOriginPk(entityPk);
        entityPk.setProgram(program);
        entityPk.setSale(sale);
        return this.create(transform, entity);
    }

    @Override
    public void update(SaleOrigin saleOrigin) {
        if (saleOrigin == null) {
            throw new IllegalArgumentException("SaleOrigin.update - 'saleOrigin' can not be null");
        }
        this.getHibernateTemplate().update((Object)saleOrigin);
    }

    @Override
    public void update(final Collection<SaleOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("SaleOrigin.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SaleOriginDaoBase.this.update((SaleOrigin)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(SaleOrigin saleOrigin) {
        if (saleOrigin == null) {
            throw new IllegalArgumentException("SaleOrigin.remove - 'saleOrigin' can not be null");
        }
        this.getHibernateTemplate().delete((Object)saleOrigin);
    }

    @Override
    public void remove(Program program, Sale sale) {
        SaleOriginPK entityPk = new SaleOriginPK();
        if (program == null) {
            throw new IllegalArgumentException("SaleOrigin.remove - 'program' can not be null");
        }
        entityPk.setProgram(program);
        if (sale == null) {
            throw new IllegalArgumentException("SaleOrigin.remove - 'sale' can not be null");
        }
        entityPk.setSale(sale);
        SaleOrigin entity = this.load(program, sale);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<SaleOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("SaleOrigin.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, SaleOrigin entity) {
        SaleOrigin target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected SaleOrigin toEntity(Object[] row) {
        SaleOrigin target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof SaleOrigin)) continue;
                target = (SaleOrigin)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SaleOriginImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SaleOriginImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<SaleOrigin> search(Search search) {
        return this.search(0, search);
    }
}

