/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.qualification;

import fr.ifremer.adagio.core.dao.data.qualification.AppliedQualificationRule;
import fr.ifremer.adagio.core.dao.data.qualification.QualifiedItemImpl;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public abstract class QualifiedItem
implements Serializable {
    private static final long serialVersionUID = 3111032275632392365L;
    private Integer id;
    private Integer objectId;
    private Timestamp updateDate;
    private Collection<AppliedQualificationRule> appliedQualificationRules = new HashSet<AppliedQualificationRule>();
    private ObjectType objectType;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Integer objectId) {
        this.objectId = objectId;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Collection<AppliedQualificationRule> getAppliedQualificationRules() {
        return this.appliedQualificationRules;
    }

    public void setAppliedQualificationRules(Collection<AppliedQualificationRule> appliedQualificationRules) {
        this.appliedQualificationRules = appliedQualificationRules;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QualifiedItem)) {
            return false;
        }
        QualifiedItem that = (QualifiedItem)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static QualifiedItem newInstance() {
            QualifiedItemImpl entity = new QualifiedItemImpl();
            return entity;
        }

        public static QualifiedItem newInstance(Integer objectId, ObjectType objectType) {
            QualifiedItem entity = Factory.newInstance();
            entity.setObjectId(objectId);
            entity.setObjectType(objectType);
            return entity;
        }

        public static QualifiedItem newInstance(Integer objectId, Timestamp updateDate, Collection<AppliedQualificationRule> appliedQualificationRules, ObjectType objectType) {
            QualifiedItem entity = Factory.newInstance();
            entity.setObjectId(objectId);
            entity.setUpdateDate(updateDate);
            entity.setAppliedQualificationRules(appliedQualificationRules);
            entity.setObjectType(objectType);
            return entity;
        }
    }
}

