/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.synchro;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.service.synchro.TuttiTableMetadata;
import java.sql.DatabaseMetaData;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class TuttiEntityTableMetadata
extends TuttiTableMetadata {
    private final String countDataToUpdateQuery;
    private final String countDataToUpdateQueryWithNull;
    private final String dataToUpdateQuery;
    private final String dataToUpdateQueryWithNull;

    public TuttiEntityTableMetadata(TableMetadata delegate, DatabaseMetaData meta) {
        super(delegate, meta);
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(this.getPkNames()));
        Preconditions.checkState((this.getPkNames().size() == 1 ? 1 : 0) != 0);
        StringBuilder queryParams = new StringBuilder("");
        for (String columnName : this.getColumnNames()) {
            queryParams.append(", ").append(columnName);
        }
        StringBuilder query = new StringBuilder("SELECT ");
        query.append(queryParams.substring(2));
        query.append(" FROM ").append(this.getName());
        this.dataToUpdateQueryWithNull = query.toString();
        this.countDataToUpdateQueryWithNull = "SELECT count(*) FROM " + this.getName();
        String whereClause = this.isWithUpdateDateColumn() ? " WHERE (update_date IS NULL OR update_date > ?)" : "";
        this.dataToUpdateQuery = this.dataToUpdateQueryWithNull + whereClause;
        this.countDataToUpdateQuery = this.countDataToUpdateQueryWithNull + whereClause;
    }

    @Override
    public String getDataToUpdateQuery() {
        return this.dataToUpdateQuery;
    }

    @Override
    public String getDataToUpdateQueryWithNull() {
        return this.dataToUpdateQueryWithNull;
    }

    @Override
    public String getCountDataToUpdateQuery() {
        return this.countDataToUpdateQuery;
    }

    @Override
    public String getCountDataToUpdateQueryWithNull() {
        return this.countDataToUpdateQueryWithNull;
    }

    @Override
    public boolean useUpdateDateColumn() {
        return true;
    }
}

