/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scientificCruiseCatchBatchValidator")
public class ScientificCruiseCatchBatchValidator
implements CatchBatchValidator {
    private static final Log log = LogFactory.getLog(ScientificCruiseCatchBatchValidator.class);
    @Autowired
    protected CatchBatchPersistenceService batchService;
    @Autowired
    protected CatchBatchExtendDao catchBatchDao;
    @Autowired
    protected TuttiEnumerationFile enumeration;

    public boolean isEnable(CatchBatch catchBatch) {
        return catchBatch.getFishingOperation() != null;
    }

    public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
        ArrayList errors = Lists.newArrayList();
        this.validate(catchBatch.getChildBatchs(), errors);
        return errors;
    }

    protected void validate(Collection<Batch> batchs, List<CatchBatchValidationError> errors) {
        SortingBatch vracBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID});
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to validate Vrac batch model " + vracBatch));
        }
        if (vracBatch == null) {
            this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            if (speciesBatch == null) {
                this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]));
            } else {
                SortingBatch aliveItemizedBatch;
                SortingBatch inertBatch;
                SortingBatch livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED});
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.catchBatchDao.getSortingBatch(speciesBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
            SortingBatch benthosBatch = this.catchBatchDao.getSortingBatch(vracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS});
            if (benthosBatch == null) {
                this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
            } else {
                SortingBatch aliveItemizedBatch;
                SortingBatch inertBatch;
                SortingBatch livingNotItemizedBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED});
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.catchBatchDao.getSortingBatch(benthosBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED})) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
        }
        SortingBatch horsVracBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID});
        if (horsVracBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch marineLitterBatch;
            SortingBatch benthosBatch;
            SortingBatch speciesBatch = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES});
            if (speciesBatch == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
            }
            if ((benthosBatch = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS})) == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracBenthosNotFound", (Object[])new Object[0]));
            }
            if ((marineLitterBatch = this.catchBatchDao.getSortingBatch(horsVracBatch.getChildBatchs(), new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER})) == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracMarineLitterNotFound", (Object[])new Object[0]));
            }
        }
        SortingBatch unsortedBatch = this.catchBatchDao.getSortingBatch(batchs, new Object[]{"pmfmId", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID});
        if (unsortedBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.unsortedNotFound", (Object[])new Object[0]));
        }
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 2);
        errors.add(error);
    }

    protected void addWarning(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 1);
        errors.add(error);
    }
}

