/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.widget.tooltip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.lang.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;
import org.nuiton.widget.tooltip.FocusableTip;
import org.nuiton.widget.tooltip.TipWindow;

public class TipUtil {
    protected static final String COPY_ICON_PATH = "copy.png";

    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color c = UIManager.getColor("ToolTip.background");
        if ((c == null || UIManager.getLookAndFeel().getName().equals("Nimbus")) && (c = UIManager.getColor("info")) == null) {
            c = SystemColor.info;
        }
        if (c instanceof ColorUIResource) {
            c = new Color(c.getRGB());
        }
        return c;
    }

    public static void tweakTipEditorPane(JEditorPane textArea) {
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            Color selBG = textArea.getSelectionColor();
            Color selFG = textArea.getSelectedTextColor();
            textArea.setUI(new BasicEditorPaneUI());
            textArea.setSelectedTextColor(selFG);
            textArea.setSelectionColor(selBG);
        }
        textArea.setEditable(false);
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        textArea.getCaret().setSelectionVisible(true);
        textArea.setBackground(TipUtil.getToolTipBackground());
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
        }
        HTMLDocument doc = (HTMLDocument)textArea.getDocument();
        doc.getStyleSheet().addRule("body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }");
    }

    public static void addCopyContextMenu(FocusableTip focusableTip) {
        if (focusableTip == null) {
            throw new NullPointerException("Focusable tip must be non null");
        }
        TipWindow tipWindows = focusableTip.getTipWindows();
        TipUtil.addCopyContextMenu(tipWindows);
    }

    protected static void addCopyContextMenu(TipWindow tipWindows) {
        if (tipWindows == null) {
            throw new NullPointerException("TipWindows must be non null");
        }
        Component component = tipWindows.getComponent();
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JEditorPane textArea = (JEditorPane)e.getSource();
                final String selectedText = textArea.getSelectedText();
                if (e.getButton() == 3 && !StringUtils.isBlank((String)selectedText)) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    ImageIcon copyIcon = Resource.getIcon((String)TipUtil.COPY_ICON_PATH);
                    JMenuItem copyMenuItem = new JMenuItem(I18n._((String)"nuitonwidgets.common.copy", (Object[])new Object[0]), copyIcon);
                    copyMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StringSelection selection = new StringSelection(selectedText);
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(selection, null);
                        }
                    });
                    popupMenu.add(copyMenuItem);
                    popupMenu.show(textArea, e.getX(), e.getY());
                }
            }
        });
    }
}

