/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.survey.sale;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SaleMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.declaration.DeclaredDocumentReference;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleDao;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleImpl;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOrigin;
import fr.ifremer.adagio.core.dao.data.survey.takeOver.TakeOver;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.SaleType;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.seller.Seller;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class SaleDaoBase
extends HibernateDaoSupport
implements SaleDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Sale.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(SaleImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Sale)entity);
    }

    @Override
    public Sale load(Integer id) {
        return (Sale)this.load(0, id);
    }

    @Override
    public Collection<Sale> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(SaleImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Sale create(Sale sale) {
        return (Sale)this.create(0, sale);
    }

    @Override
    public Object create(int transform, Sale sale) {
        if (sale == null) {
            throw new IllegalArgumentException("Sale.create - 'sale' can not be null");
        }
        this.getHibernateTemplate().save((Object)sale);
        return this.transformEntity(transform, sale);
    }

    @Override
    public Collection<Sale> create(Collection<Sale> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Sale> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sale.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SaleDaoBase.this.create(transform, (Sale)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Sale create(Date saleStartDate, Date saleEndDate, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, CatchBatch catchBatch, TakeOver takeOver, DeclaredDocumentReference declaredDocumentReference, Collection<SaleOrigin> saleOrigins, Program program, Person recorderPerson, Seller seller, Department recorderDepartment, QualityFlag qualityFlag, Vessel vessel, FishingTrip fishingTrip, Location saleLocation, SaleType saleType, Landing landing, Collection<FishingArea> fishingAreas, Collection<SaleMeasurement> saleMeasurements, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
        return (Sale)this.create(0, saleStartDate, saleEndDate, synchronizationStatus, comments, creationDate, controlDate, validationDate, qualificationDate, qualificationComments, updateDate, catchBatch, takeOver, declaredDocumentReference, saleOrigins, program, recorderPerson, seller, recorderDepartment, qualityFlag, vessel, fishingTrip, saleLocation, saleType, landing, fishingAreas, saleMeasurements, surveyMeasurements, produces);
    }

    @Override
    public Object create(int transform, Date saleStartDate, Date saleEndDate, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, CatchBatch catchBatch, TakeOver takeOver, DeclaredDocumentReference declaredDocumentReference, Collection<SaleOrigin> saleOrigins, Program program, Person recorderPerson, Seller seller, Department recorderDepartment, QualityFlag qualityFlag, Vessel vessel, FishingTrip fishingTrip, Location saleLocation, SaleType saleType, Landing landing, Collection<FishingArea> fishingAreas, Collection<SaleMeasurement> saleMeasurements, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
        SaleImpl entity = new SaleImpl();
        entity.setSaleStartDate(saleStartDate);
        entity.setSaleEndDate(saleEndDate);
        entity.setSynchronizationStatus(synchronizationStatus);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setControlDate(controlDate);
        entity.setValidationDate(validationDate);
        entity.setQualificationDate(qualificationDate);
        entity.setQualificationComments(qualificationComments);
        entity.setUpdateDate(updateDate);
        entity.setCatchBatch(catchBatch);
        entity.setTakeOver(takeOver);
        entity.setDeclaredDocumentReference(declaredDocumentReference);
        entity.setSaleOrigins(saleOrigins);
        entity.setProgram(program);
        entity.setRecorderPerson(recorderPerson);
        entity.setSeller(seller);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setQualityFlag(qualityFlag);
        entity.setVessel(vessel);
        entity.setFishingTrip(fishingTrip);
        entity.setSaleLocation(saleLocation);
        entity.setSaleType(saleType);
        entity.setLanding(landing);
        entity.setFishingAreas(fishingAreas);
        entity.setSaleMeasurements(saleMeasurements);
        entity.setSurveyMeasurements(surveyMeasurements);
        entity.setProduces(produces);
        return this.create(transform, entity);
    }

    @Override
    public Sale create(Date creationDate, Program program, QualityFlag qualityFlag, Department recorderDepartment, Location saleLocation, Date saleStartDate, SaleType saleType, String synchronizationStatus, Vessel vessel) {
        return (Sale)this.create(0, creationDate, program, qualityFlag, recorderDepartment, saleLocation, saleStartDate, saleType, synchronizationStatus, vessel);
    }

    @Override
    public Object create(int transform, Date creationDate, Program program, QualityFlag qualityFlag, Department recorderDepartment, Location saleLocation, Date saleStartDate, SaleType saleType, String synchronizationStatus, Vessel vessel) {
        SaleImpl entity = new SaleImpl();
        entity.setCreationDate(creationDate);
        entity.setProgram(program);
        entity.setQualityFlag(qualityFlag);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setSaleLocation(saleLocation);
        entity.setSaleStartDate(saleStartDate);
        entity.setSaleType(saleType);
        entity.setSynchronizationStatus(synchronizationStatus);
        entity.setVessel(vessel);
        return this.create(transform, entity);
    }

    @Override
    public void update(Sale sale) {
        if (sale == null) {
            throw new IllegalArgumentException("Sale.update - 'sale' can not be null");
        }
        this.getHibernateTemplate().update((Object)sale);
    }

    @Override
    public void update(final Collection<Sale> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sale.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SaleDaoBase.this.update((Sale)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Sale sale) {
        if (sale == null) {
            throw new IllegalArgumentException("Sale.remove - 'sale' can not be null");
        }
        this.getHibernateTemplate().delete((Object)sale);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Sale.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Sale entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Sale> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sale.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Sale entity) {
        Sale target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Sale toEntity(Object[] row) {
        Sale target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Sale)) continue;
                target = (Sale)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SaleImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SaleImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Sale> search(Search search) {
        return this.search(0, search);
    }
}

