/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao;

import fr.ifremer.adagio.core.dao.CriteriaSearch;
import fr.ifremer.adagio.core.dao.CriteriaSearchParameter;
import fr.ifremer.adagio.core.dao.CriteriaSearchProperties;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.SearchParameter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

public class PropertySearch
extends CriteriaSearch {
    private Search search;
    private int totalCount;
    private static final String PERIOD = ".";

    public PropertySearch(Session session, Class entityType, Search search) {
        super(session, entityType);
        this.search = search;
        try {
            this.initializeConverters();
            this.getConfiguration().setForceEagerLoading(search.isEagerFetching());
            SearchParameter[] parameters = search.getParameters();
            if (parameters != null) {
                for (int ctr = 0; ctr < parameters.length; ++ctr) {
                    Object value;
                    SearchParameter searchParameter = parameters[ctr];
                    switch (searchParameter.getComparator()) {
                        case 7: {
                            value = searchParameter.getValue();
                            break;
                        }
                        case 11: {
                            value = searchParameter.getValue();
                            break;
                        }
                        default: {
                            value = this.getValue(entityType, searchParameter);
                        }
                    }
                    CriteriaSearchParameter parameter = new CriteriaSearchParameter(value, searchParameter.getName(), searchParameter.getComparator());
                    parameter.setOrderDirection(searchParameter.getOrder());
                    parameter.setSearchIfNull(searchParameter.isSearchIfNull());
                    switch (searchParameter.getMatch()) {
                        case 0: {
                            parameter.setMatchMode(MatchMode.ANYWHERE);
                            break;
                        }
                        case 1: {
                            parameter.setMatchMode(MatchMode.START);
                            break;
                        }
                        case 2: {
                            parameter.setMatchMode(MatchMode.END);
                            break;
                        }
                        default: {
                            parameter.setMatchMode(MatchMode.EXACT);
                        }
                    }
                    this.addParameter(parameter);
                    if (!search.isUseSqlLimiting() || search.getPageNumber() <= 0 || search.getPageSize() <= 0) continue;
                    this.getConfiguration().setFirstResult(new Integer(this.calculateFirstResult(search.getPageNumber(), search.getPageSize())));
                    this.getConfiguration().setMaximumResultSize(new Integer(search.getPageSize()));
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public int getTotalCount() {
        int totalCount;
        if (this.search.isUseSqlLimiting()) {
            this.getConfiguration().setFirstResult(new Integer(0));
            this.getRootCriteria().setProjection((Projection)Projections.projectionList().add(Projections.rowCount()));
            totalCount = ((Long)this.executeAsList().iterator().next()).intValue();
        } else {
            totalCount = this.totalCount;
        }
        return totalCount;
    }

    @Override
    public List executeAsList() throws HibernateException {
        List results = super.executeAsList();
        if (!this.search.isUseSqlLimiting() && this.search.getPageNumber() > 0 && this.search.getPageSize() > 0) {
            int start = this.calculateFirstResult(this.search.getPageNumber(), this.search.getPageSize());
            int end = this.calculateLastResult(this.search.getPageNumber(), this.search.getPageSize());
            this.totalCount = results.size();
            if (this.totalCount < start) {
                start = this.totalCount;
            }
            if (this.totalCount < end) {
                end = this.totalCount;
            }
            results = results.subList(start, end);
        }
        return results;
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0 && pageSize > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    private int calculateLastResult(int pageNumber, int pageSize) {
        int lastResult = 0;
        if (pageNumber > 0 && pageSize > 0) {
            lastResult = pageNumber * pageSize;
        }
        return lastResult;
    }

    private void initializeConverters() {
        ConvertUtils.register((Converter)new LongConverter(null), Long.class);
        ConvertUtils.register((Converter)new IntegerConverter(null), Integer.class);
        ConvertUtils.register((Converter)new ShortConverter(null), Short.class);
        ConvertUtils.register((Converter)new CalendarConverter(), Calendar.class);
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
    }

    private Object getValue(Class type, SearchParameter parameter) {
        try {
            Object value = parameter.getValue();
            if (value != null && !value.getClass().equals(Class.class)) {
                Class propertyType = type;
                StringTokenizer tokenizer = new StringTokenizer(parameter.getName(), PERIOD);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken().trim();
                    Class lastType = type;
                    type = CriteriaSearchProperties.getPropertyType(type, token);
                    if (!tokenizer.hasMoreTokens()) break;
                    if (type == null) {
                        throw new RuntimeException("No accessible property named '" + token + "', exists on: " + lastType.getName());
                    }
                    propertyType = type;
                }
                String name = parameter.getName().replaceAll(".*\\.", "");
                Object object = propertyType.newInstance();
                BeanUtils.copyProperty(object, (String)name, (Object)value);
                try {
                    value = PropertyUtils.getProperty(object, (String)name);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("No accessible property named '" + name + "', exists on: " + propertyType.getName());
                }
            }
            return value;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static final class CalendarConverter
    implements Converter {
        public Object convert(Class type, Object value) throws ConversionException {
            if (value != null) {
                try {
                    if (value instanceof Date) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)value);
                        value = calendar;
                    }
                }
                catch (Exception ex) {
                    throw new ConversionException((Throwable)ex);
                }
            }
            return value;
        }
    }

    private static final class DateConverter
    implements Converter {
        public Object convert(Class type, Object value) throws ConversionException {
            if (value != null) {
                try {
                    if (value instanceof Calendar) {
                        value = ((Calendar)value).getTime();
                    }
                }
                catch (Exception ex) {
                    throw new ConversionException((Throwable)ex);
                }
            }
            return value;
        }
    }
}

