/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionSwingWorker;
import java.awt.event.ActionEvent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiUIAction<A extends AbstractTuttiAction>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TuttiUIAction.class);
    public static final ExecutorService waitingThread = Executors.newSingleThreadExecutor();
    private static final String LOGIC_ACTION = "logicAction";

    public TuttiUIAction(AbstractButton button, A action) {
        this.putValue(LOGIC_ACTION, action);
        this.setActionKey(action.getClass().getName());
        if (button != null) {
            this.setActionIcon(button.getIcon());
            this.setActionName(button.getText());
            this.setActionDescription(button.getToolTipText());
            this.setActionMnemonic(button.getMnemonic());
        }
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        boolean doAction;
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this + "] starting"));
        }
        A action = this.getLogicAction();
        ((AbstractTuttiAction)((Object)action)).sendMessage("");
        try {
            doAction = ((AbstractTuttiAction)((Object)action)).prepareAction();
        }
        catch (Exception e) {
            ((AbstractTuttiAction)((Object)action)).releaseAction();
            throw TuttiActionException.propagateError(action, e);
        }
        if (doAction) {
            final TuttiActionSwingWorker<A> worker = new TuttiActionSwingWorker<A>(action);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    worker.updateBusyState(true);
                }
            });
            if (log.isInfoEnabled()) {
                log.info((Object)("Before execute of action " + action));
            }
            worker.execute();
            waitingThread.execute(new Runnable(){

                @Override
                public void run() {
                    Object action = TuttiUIAction.this.getLogicAction();
                    try {
                        worker.get();
                    }
                    catch (ExecutionException e) {
                    }
                    catch (CancellationException e) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("After execute of action " + action + " (worker done? " + worker.isDone() + ")"));
                    }
                    if (worker.isFailed()) {
                        throw TuttiActionException.propagateError(action, worker.getError());
                    }
                }
            });
        } else {
            ((AbstractTuttiAction)((Object)action)).releaseAction();
        }
    }

    public void setActionIcon(Icon actionIcon) {
        this.putValue("SmallIcon", actionIcon);
        this.putValue("SwingLargeIconKey", actionIcon);
    }

    public void setActionKey(String actionKey) {
        this.putValue("ActionCommandKey", actionKey);
    }

    public void setActionName(String actionName) {
        this.putValue("Name", actionName);
    }

    public void setActionDescription(String actionDescription) {
        this.putValue("ShortDescription", actionDescription);
        ((AbstractTuttiAction)((Object)this.getLogicAction())).setActionDescription(actionDescription);
    }

    public void setActionMnemonic(int key) {
        this.putValue("MnemonicKey", key);
    }

    public A getLogicAction() {
        return (A)((Object)((AbstractTuttiAction)((Object)this.getValue(LOGIC_ACTION))));
    }
}

