/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.util.ArrayList;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);
    private final PersistenceService persistenceService;

    public static String getTitle(boolean exist) {
        String result = exist ? I18n._((String)"tutti.editProgram.title.edit.program", (Object[])new Object[0]) : I18n._((String)"tutti.editProgram.title.create.program", (Object[])new Object[0]);
        return result;
    }

    public EditProgramUIHandler(TuttiUI parentUi, EditProgramUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public void beforeInitUI() {
        EditProgramUIModel model = new EditProgramUIModel();
        ArrayList programs = Lists.newArrayList((Iterable)this.persistenceService.getAllProgram());
        model.setExistingPrograms(programs);
        String programId = this.context.getProgramId();
        if (programId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + programId));
            }
            Program program = this.persistenceService.getProgram(programId);
            model.fromBean(program);
            model.getExistingPrograms().remove(program);
        }
        this.listModelIsModify(model);
        ((EditProgramUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditProgramUIModel model = (EditProgramUIModel)this.getModel();
        this.initBeanFilterableComboBox(((EditProgramUI)this.ui).getZoneComboBox(), this.persistenceService.getAllProgramZone(), model.getZone());
        SwingValidator<EditProgramUIModel> validator = ((EditProgramUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        model.setModify(model.isCreate());
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean quitUI() {
        boolean result = this.quitScreen(((EditProgramUIModel)this.getModel()).isValid(), ((EditProgramUIModel)this.getModel()).isModify(), I18n._((String)"tutti.editProgram.askCancelEditBeforeLeaving.cancelSaveProgram", (Object[])new Object[0]), I18n._((String)"tutti.editProgram.askSaveBeforeLeaving.saveProgram", (Object[])new Object[0]), ((EditProgramUI)this.ui).getSaveButton().getAction());
        return result;
    }

    @Override
    public SwingValidator<EditProgramUIModel> getValidator() {
        return ((EditProgramUI)this.ui).getValidator();
    }
}

