/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.HashMap;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;

public class EngineEmitterServices
implements IEmitterServices {
    protected HashMap configs;
    protected IRenderOption renderOptions;
    protected IReportContext reportContext;

    public EngineEmitterServices(IReportContext reportContext, IRenderOption renderOptions, HashMap configs) {
        this.configs = configs;
        this.reportContext = reportContext;
        this.renderOptions = renderOptions;
    }

    @Override
    public HashMap getEmitterConfig() {
        return this.configs;
    }

    @Override
    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    @Override
    public String getReportName() {
        IReportRunnable runnable = this.reportContext.getReportRunnable();
        if (runnable != null) {
            return runnable.getReportName();
        }
        return null;
    }

    @Override
    public Object getOption(String name) {
        if (this.renderOptions != null) {
            return this.renderOptions.getOption(name);
        }
        return null;
    }

    @Override
    public Object getRenderContext() {
        if (this.reportContext != null) {
            return this.reportContext.getAppContext();
        }
        return null;
    }

    @Override
    public IReportRunnable getReportRunnable() {
        if (this.reportContext != null) {
            return this.reportContext.getReportRunnable();
        }
        return null;
    }

    @Override
    public IReportContext getReportContext() {
        return this.reportContext;
    }

    @Override
    public IReportEngine getReportEngine() {
        if (this.reportContext != null) {
            return this.reportContext.getReportRunnable().getReportEngine();
        }
        return null;
    }
}

