/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersTableCellRenderer;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellEditor;
import fr.ifremer.isisfish.ui.models.rule.RuleParametersFactorTableCellRenderer;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleChooserHandler {
    private static final Log log = LogFactory.getLog(RuleChooserHandler.class);
    protected RuleChooser ruleChooser;

    public RuleChooserHandler(RuleChooser ruleChooser) {
        this.ruleChooser = ruleChooser;
    }

    protected void afterInit() {
        this.ruleChooser.addPropertyChangeListener("rulesList", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    RuleChooserHandler.this.ruleChooser.selectedRulesListModel.setElementList(new ArrayList());
                } else {
                    List rules = (List)evt.getNewValue();
                    RuleChooserHandler.this.ruleChooser.selectedRulesListModel.setElementList(rules);
                }
            }
        });
        if (this.ruleChooser.isShowFactorColumn().booleanValue()) {
            SwingUtil.fixTableColumnWidth((JTable)this.ruleChooser.selectedRuleParameterTable, (int)2, (int)30);
        }
        this.setupSelectedListDnD();
    }

    protected void setupSelectedListDnD() {
        final JList<Rule> selectedRuleList = this.ruleChooser.getSelectedRulesList();
        selectedRuleList.setDragEnabled(true);
        selectedRuleList.setDropMode(DropMode.INSERT);
        selectedRuleList.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 7821083182552085625L;

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                JList.DropLocation dl;
                boolean result = false;
                if (support.isDataFlavorSupported(DataFlavor.stringFlavor) && (dl = (JList.DropLocation)support.getDropLocation()).getIndex() != -1) {
                    return true;
                }
                return result;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                boolean result = false;
                if (this.canImport(support)) {
                    Transferable transferable = support.getTransferable();
                    try {
                        String indexString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        int index = Integer.parseInt(indexString);
                        JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
                        int dropTargetIndex = dl.getIndex();
                        List<Rule> rules = RuleChooserHandler.this.ruleChooser.getRulesList();
                        Rule rule = rules.remove(index);
                        rules.add(dropTargetIndex, rule);
                        selectedRuleList.setSelectedIndex(dropTargetIndex);
                        result = true;
                    }
                    catch (Exception e) {
                        result = false;
                    }
                }
                return result;
            }
        });
        final DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(selectedRuleList, 2, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                StringSelection transferable = new StringSelection(Integer.toString(selectedRuleList.getSelectedIndex()));
                ds.startDrag(dge, DragSource.DefaultCopyDrop, transferable, null);
            }
        });
    }

    protected void addSelectedRules() {
        List<String> availableRuleValues = this.ruleChooser.getAvailableRuleList().getSelectedValuesList();
        for (String availableRuleName : availableRuleValues) {
            try {
                RuleStorage ruleStorage = RuleStorage.getRule(availableRuleName, new CodeSourceStorage.Location[0]);
                Rule ruleTmp = (Rule)ruleStorage.getNewInstance();
                if ((ruleTmp = (Rule)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)this.ruleChooser, ruleTmp)) == null) continue;
                this.ruleChooser.getRulesList().add(ruleTmp);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't add rule", ex);
            }
        }
        this.ruleChooser.getSelectedRulesListModel().setElementList(this.ruleChooser.getRulesList());
    }

    protected void removeSelectedRules() {
        List<Rule> selectedRuleValues = this.ruleChooser.getSelectedRulesList().getSelectedValuesList();
        for (Rule selectedRuleValue : selectedRuleValues) {
            if (this.ruleChooser.isShowFactorColumn().booleanValue()) {
                int ruleIndex = this.ruleChooser.getRulesList().indexOf(selectedRuleValue);
                this.preRemoveRule(ruleIndex);
                this.ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
            }
            this.ruleChooser.getRulesList().remove(selectedRuleValue);
        }
        this.ruleChooser.getSelectedRulesListModel().setElementList(this.ruleChooser.getRulesList());
        this.ruleChooser.getSelectedRulesList().clearSelection();
    }

    protected void clearAllRules() {
        if (this.ruleChooser.isShowFactorColumn().booleanValue()) {
            for (Rule rule : this.ruleChooser.getRulesList()) {
                int ruleIndex = this.ruleChooser.getRulesList().indexOf(rule);
                this.preRemoveRule(ruleIndex);
            }
            this.ruleChooser.getContextValue(SimulationUI.class, "SimulationUI").refreshFactorTree();
        }
        this.ruleChooser.getRulesList().clear();
        this.ruleChooser.getSelectedRulesListModel().setElementList(this.ruleChooser.getRulesList());
        this.ruleChooser.getSelectedRulesList().clearSelection();
    }

    protected void displayRuleParameters() {
        Rule selectedRule = this.ruleChooser.getSelectedRulesList().getSelectedValue();
        if (selectedRule != null) {
            this.ruleChooser.getSelectedRuleParameterTableModel().setScript(selectedRule);
            ScriptParametersTableCellRenderer cellRenderer = new ScriptParametersTableCellRenderer(selectedRule);
            this.ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
            ScriptParametersTableCellEditor cellEditor = new ScriptParametersTableCellEditor(selectedRule);
            cellEditor.setRegionStorage(this.ruleChooser.getContextValue(RegionStorage.class));
            this.ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(1).setCellEditor(cellEditor);
            if (this.ruleChooser.isShowFactorColumn().booleanValue()) {
                RuleParametersFactorTableCellRenderer sensitivityRenderer = new RuleParametersFactorTableCellRenderer(this.ruleChooser, selectedRule);
                this.ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellRenderer(sensitivityRenderer);
                RuleParametersFactorTableCellEditor sensitivityEditor = new RuleParametersFactorTableCellEditor(this.ruleChooser, selectedRule);
                this.ruleChooser.getSelectedRuleParameterTable().getColumnModel().getColumn(2).setCellEditor(sensitivityEditor);
            }
        } else {
            this.ruleChooser.getSelectedRuleParameterTableModel().setScript(null);
        }
    }

    public void preRemoveRule(int ruleIndex) {
        this.preRemoveRule(this.ruleChooser.getContextValue(FactorGroup.class), ruleIndex);
    }

    protected void preRemoveRule(FactorGroup factorGroup, int ruleIndex) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.preRemoveRule((FactorGroup)factor, ruleIndex);
                continue;
            }
            Pattern factorPathPattern = Pattern.compile("^(parameters\\.rule\\.)(\\d+)(.*)$");
            Matcher factorPathMatcher = factorPathPattern.matcher(factor.getPath());
            if (!factorPathMatcher.find()) continue;
            Integer index = Integer.parseInt(factorPathMatcher.group(2));
            if (index == ruleIndex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing factor for index " + ruleIndex + " : " + factor.getPath()));
                }
                factorGroup.remove(factor);
                continue;
            }
            if (index <= ruleIndex) continue;
            String factorPath = factorPathMatcher.group(1) + String.valueOf(index - 1) + factorPathMatcher.group(3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Renammed factor for index " + ruleIndex + " : " + factor.getPath()));
            }
            factor.setPath(factorPath);
        }
    }
}

