/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.simulationplan;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.util.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class SimulationPlanComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, SimulationPlan> simulationPlanCache = new HashMap<String, SimulationPlan>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String simulationPlanName = (String)value;
        String text = null;
        try {
            SimulationPlan plan = this.simulationPlanCache.get(simulationPlanName);
            if (plan == null) {
                SimulationPlanStorage storage = SimulationPlanStorage.getSimulationPlan(simulationPlanName, new CodeSourceStorage.Location[0]);
                plan = (SimulationPlan)storage.getNewInstance();
                this.simulationPlanCache.put(simulationPlanName, plan);
            }
            text = RendererHelper.getNameAndDocComboString(simulationPlanName, plan.getDescription());
        }
        catch (Exception e) {
            text = RendererHelper.getNameAndCompComboString(simulationPlanName);
        }
        c.setText(text);
        return c;
    }
}

