/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.result.ResultInfoHelper;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class ResultManager {
    private static Log log = LogFactory.getLog(ResultManager.class);
    protected SimulationContext context = null;
    protected Set<SimulationResultListener> listeners = new LinkedHashSet<SimulationResultListener>();
    protected SimulationResultGetter getter = null;
    protected transient Set<String> enabledResult = null;

    public ResultManager(SimulationContext context) {
        this.context = context;
    }

    protected void addSimulationResultListener(SimulationResultListener l) {
        this.listeners.add(l);
        if (l instanceof SimulationResultGetter) {
            this.getter = (SimulationResultGetter)((Object)l);
        }
    }

    protected void removeSimulationResultListener(SimulationResultListener l) {
        this.listeners.remove(l);
        if (l == this.getter) {
            this.getter = null;
            for (SimulationResultListener i : this.listeners) {
                if (!(i instanceof SimulationResultGetter)) continue;
                this.getter = (SimulationResultGetter)((Object)i);
                break;
            }
        }
    }

    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            Map<ExportInfo, Observation> optimizationExportsObservations;
            Optimization optimization;
            Objective objective;
            List<SimulationPlan> list;
            int n;
            List<Rule> list2;
            List<SensitivityExport> sensitivityExports;
            int n2;
            SimulationParameter param = this.context.getSimulationStorage().getParameter();
            Set<String> requestedResult = ResultInfoHelper.cleanResultNames(param.getResultEnabled());
            List<String> exportNames = param.getExportNames();
            if (exportNames != null) {
                for (String string : exportNames) {
                    ExportStorage exportStorage = ExportStorage.getExport(string, new CodeSourceStorage.Location[0]);
                    try {
                        ExportInfo exportInfo = (ExportInfo)exportStorage.getNewInstance();
                        String[] stringArray = exportInfo.getNecessaryResult();
                        n2 = stringArray.length;
                        for (int i = 0; i < n2; ++i) {
                            String resultName = stringArray[i];
                            requestedResult.add(resultName);
                        }
                    }
                    catch (IsisFishException isisFishException) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n.t((String)"Can't instanciate export %1$s", (Object[])new Object[]{string}), (Throwable)isisFishException);
                    }
                }
            }
            if ((sensitivityExports = param.getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    for (String resultName2 : sensitivityExport.getNecessaryResult()) {
                        requestedResult.add(resultName2);
                    }
                }
            }
            if ((list2 = param.getRules()) != null) {
                for (Rule rule : list2) {
                    String[] stringArray = rule.getNecessaryResult();
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String resultName3 = stringArray[n];
                        requestedResult.add(resultName3);
                    }
                }
            }
            if ((list = param.getSimulationPlans()) != null) {
                for (SimulationPlan plan : list) {
                    String[] stringArray = plan.getNecessaryResult();
                    n = stringArray.length;
                    for (int resultName3 = 0; resultName3 < n; ++resultName3) {
                        String resultName4 = stringArray[resultName3];
                        requestedResult.add(resultName4);
                    }
                }
            }
            if ((objective = param.getObjective()) != null) {
                for (String resultName5 : objective.getNecessaryResult()) {
                    requestedResult.add(resultName5);
                }
            }
            if ((optimization = param.getOptimization()) != null) {
                for (String resultName : optimization.getNecessaryResult()) {
                    requestedResult.add(resultName);
                }
            }
            if ((optimizationExportsObservations = param.getOptimizationExportsObservations()) != null) {
                for (ExportInfo export : optimizationExportsObservations.keySet()) {
                    for (String resultName6 : export.getNecessaryResult()) {
                        requestedResult.add(resultName6);
                    }
                }
            }
            this.enabledResult = ResultInfoHelper.extractAllNecessaryResults(requestedResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Enabled result: " + this.enabledResult));
            }
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        log.warn((Object)"addActiveRule not implemented");
    }

    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name + " " + pop, mat);
            }
        }
    }

    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            for (SimulationResultListener l : this.listeners) {
                l.addResult(this.context, step, name, mat);
            }
        }
    }

    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        name = name + " " + pop;
        return this.getMatrix(step, name);
    }

    public MatrixND getMatrix(TimeStep step, String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, step, name);
        }
        return result;
    }

    public MatrixND getMatrix(List<TimeStep> steps, Population pop, String name) {
        name = name + " " + pop;
        return this.getMatrix(steps, name);
    }

    public MatrixND getMatrix(List<TimeStep> steps, String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, steps, name);
        }
        return result;
    }

    public MatrixND getMatrix(Population pop, String name) {
        name = name + " " + pop;
        return this.getMatrix(name);
    }

    public MatrixND getMatrix(String name) {
        MatrixND result = null;
        if (this.getter != null) {
            result = this.getter.getMatrix(this.context, name);
        }
        return result;
    }
}

