/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico.xml;

import fr.ifremer.isisfish.mexico.xml.AbstractXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.ContinuousDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.EquationDiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.RuleDiscreteDomainXMLVisitor;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.RuleDiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import org.apache.commons.lang3.StringUtils;

public class FactorXMLVisitor
extends AbstractXMLVisitor
implements FactorVisitor {
    protected FactorGroup group;

    public FactorXMLVisitor(FactorGroup group) {
        this.group = group;
    }

    @Override
    public void start(Factor factor) {
        String factorId = factor.getPath();
        if (StringUtils.isNotBlank((CharSequence)factor.getEquationVariableName())) {
            factorId = factorId + "." + factor.getEquationVariableName();
        }
        this.xmlBuffer.append("<factor");
        this.xmlBuffer.append(" id=\"").append(factorId).append("\"");
        this.xmlBuffer.append(" name=\"").append(factor.getName()).append("\"");
        if (StringUtils.isNotBlank((CharSequence)factor.getComment())) {
            this.xmlBuffer.append(" description=\"").append(factor.getComment()).append("\"");
        }
        this.xmlBuffer.append(">");
        this.xmlBuffer.append("<feature name=\"cardinality\">" + factor.getCardinality() + "</feature>");
        if (StringUtils.isNotBlank((CharSequence)this.group.getName())) {
            this.xmlBuffer.append("<feature name=\"group\">" + this.group.getName() + "</feature>");
            this.xmlBuffer.append("<feature name=\"grouptype\">");
            if (this.group.isContinuous()) {
                this.xmlBuffer.append("continuous");
            } else {
                this.xmlBuffer.append("discrete");
            }
            this.xmlBuffer.append("</feature>");
        }
        this.xmlBuffer.append("<feature name=\"target\">" + factor.getPath() + "</feature>");
        if (StringUtils.isNotBlank((CharSequence)factor.getEquationVariableName())) {
            this.xmlBuffer.append("<feature name=\"equationVariableName\">" + factor.getEquationVariableName() + "</feature>");
        }
    }

    @Override
    public void visit(Factor factor, Domain domain) {
        DomainXMLVisitor visitor = null;
        if (factor.getDomain() instanceof ContinuousDomain) {
            visitor = new ContinuousDomainXMLVisitor();
        } else if (factor.getDomain() instanceof RuleDiscreteDomain) {
            visitor = new RuleDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof EquationDiscreteDomain) {
            visitor = new EquationDiscreteDomainXMLVisitor();
        } else if (factor.getDomain() instanceof DiscreteDomain) {
            visitor = new DiscreteDomainXMLVisitor();
        }
        domain.accept(visitor);
        this.xmlBuffer.append(visitor.getXML());
    }

    @Override
    public void end(Factor factor) {
        this.xmlBuffer.append("</factor>");
    }
}

