/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfoImpl;
import fr.ifremer.isisfish.entities.TripTypeAbstract;
import fr.ifremer.isisfish.types.TimeUnit;
import java.util.List;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class TripTypeImpl
extends TripTypeAbstract {
    private static final long serialVersionUID = 1L;

    public TripTypeImpl() {
        this.setMinTimeBetweenTrip(new TimeUnit(0.0));
        this.setTripDuration(new TimeUnit(0.0));
    }

    @Override
    public void setTripDuration(TimeUnit tripDuration) {
        super.setTripDuration(tripDuration);
        TopiaContext context = this.getTopiaContext();
        if (context != null) {
            try {
                StrategyMonthInfoDAO smiDAO = IsisFishDAOHelper.getStrategyMonthInfoDAO(context);
                List smis = smiDAO.findAllByTripType(this);
                for (StrategyMonthInfo smi : smis) {
                    StrategyMonthInfoImpl smiImpl = (StrategyMonthInfoImpl)smi;
                    smiImpl.computeNumberOfTrips();
                    smi.update();
                }
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException("Can't get fishery region", eee);
            }
        }
    }

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't get fishery region", eee);
        }
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

