/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CellDAOAbstract<E extends Cell>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Cell.class;
    }

    public IsisFishDAOHelper.IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishDAOHelper.IsisFishEntityEnum.Cell;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getHibernate().createSQLQuery(" SELECT main.* FROM zone main, cell_zone secondary WHERE main.topiaid = secondary.zone AND secondary.cell = ?").addEntity("main", IsisFishDAOHelper.getImplementationClass(Zone.class)).setString(0, entity.getTopiaId()).list();
        for (Object item : list) {
            item.removeCell((Cell)entity);
        }
        list = this.getContext().getDAO(Port.class).findAllByProperties("cell", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getCell())) continue;
            item.setCell(null);
        }
        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        Cell result = (Cell)this.findByProperty("name", v);
        return (E)result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List result = this.findAllByProperty("name", v);
        return result;
    }

    public E findByLatitude(float v) throws TopiaException {
        Cell result = (Cell)this.findByProperty("latitude", Float.valueOf(v));
        return (E)result;
    }

    public List<E> findAllByLatitude(float v) throws TopiaException {
        List result = this.findAllByProperty("latitude", Float.valueOf(v));
        return result;
    }

    public E findByLongitude(float v) throws TopiaException {
        Cell result = (Cell)this.findByProperty("longitude", Float.valueOf(v));
        return (E)result;
    }

    public List<E> findAllByLongitude(float v) throws TopiaException {
        List result = this.findAllByProperty("longitude", Float.valueOf(v));
        return result;
    }

    public E findByLand(boolean v) throws TopiaException {
        Cell result = (Cell)this.findByProperty("land", v);
        return (E)result;
    }

    public List<E> findAllByLand(boolean v) throws TopiaException {
        List result = this.findAllByProperty("land", v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        Cell result = (Cell)this.findByProperty("comment", v);
        return (E)result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List result = this.findAllByProperty("comment", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == Port.class) {
            dao = (PortDAO)this.getContext().getDAO(Port.class);
            tmp = dao.findAllByCell((Cell)entity);
            result.addAll(tmp);
        }
        if (type == Zone.class) {
            dao = (ZoneDAO)this.getContext().getDAO(Zone.class);
            tmp = dao.findAllContainsCell((Cell)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        List<Object> list = this.findUsages(Port.class, entity);
        if (!list.isEmpty()) {
            result.put(Port.class, list);
        }
        if (!(list = this.findUsages(Zone.class, entity)).isEmpty()) {
            result.put(Zone.class, list);
        }
        return result;
    }
}

