/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.aspect;

import fr.ifremer.isisfish.datastore.SimulationInformation;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RuleAspect {
    private static Log log = LogFactory.getLog(RuleAspect.class);

    @Around(value="execution(* rules.*.init(..))")
    public Object initCall(ProceedingJoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, 0);
        return result;
    }

    @Around(value="execution(* rules.*.preAction(..))")
    public Object initPreCall(ProceedingJoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, 1);
        return result;
    }

    @Around(value="execution(* rules.*.postAction(..))")
    public Object initPostCall(ProceedingJoinPoint jp) throws Throwable {
        Object result = this.makeTimedCall(jp, 2);
        return result;
    }

    protected Object makeTimedCall(ProceedingJoinPoint jp, int state) throws Throwable {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rule aspect called : " + jp.getTarget().getClass().getSimpleName()));
        }
        long timeBeforeCall = System.currentTimeMillis();
        Object result = jp.proceed();
        long timeAfterCall = System.currentTimeMillis();
        long timeTaken = timeAfterCall - timeBeforeCall;
        this.registerTime((JoinPoint)jp, state, timeTaken);
        return result;
    }

    protected void registerTime(JoinPoint jp, int state, long timeTaken) {
        SimulationContext context = SimulationContext.get();
        SimulationStorage simulation = context.getSimulationStorage();
        if (simulation != null) {
            Class<?> calleeClass = jp.getTarget().getClass();
            String ruleName = calleeClass.getSimpleName();
            SimulationInformation info = simulation.getInformation();
            switch (state) {
                case 0: {
                    info.addRuleInitTime(ruleName, timeTaken);
                    break;
                }
                case 1: {
                    info.addRulePreTime(ruleName, timeTaken);
                    break;
                }
                case 2: {
                    info.addRulePostTime(ruleName, timeTaken);
                    break;
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Time register called outside a simulation context");
        }
    }
}

