/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationCapturabilityEquation.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/equation/PopulationCapturabilityEquation.java $
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;

/**
 * Population capturability equation.
 *
 * Created: 23 août 2006 11:11:40
 *
 * @author poussin
 * @version $Revision: 4156 $
 *
 * Last update: $Date: 2014-12-09 12:27:18 +0100 (mar., 09 déc. 2014) $
 * by : $Author: echatellier $
 */
public interface PopulationCapturabilityEquation {

    /**
     * Compute capturability equation.
     * 
     * @param context simulation context
     * @param pop population pour lequel on souhaite la matrice de reproduction
     * @param group le group de la population
     * @param season la saison de la population
     * 
     * @return la valeur retournée n'est pas utilisée, par exemple 'return 0;'
     * convient.
     * @throws Exception 
     */
    @Args({"context", "pop", "group", "season"})
    @ArgTypes({
        "fr.ifremer.isisfish.simulator.SimulationContext",
        "fr.ifremer.isisfish.entities.Population", 
        "fr.ifremer.isisfish.entities.PopulationGroup", 
        "fr.ifremer.isisfish.entities.PopulationSeasonInfo"})
    public double compute(SimulationContext context, Population pop,
            PopulationGroup group, PopulationSeasonInfo season) throws Exception;

}
