/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class IsisMatrixSemanticMapper
extends SemanticMapper {
    private static Log log = LogFactory.getLog(IsisMatrixSemanticMapper.class);

    public Class getType(String typeName) {
        Class<Object> clazz = null;
        try {
            clazz = Class.forName("fr.ifremer.isisfish.entities." + typeName);
        }
        catch (Exception ex) {
            try {
                clazz = Class.forName("fr.ifremer.isisfish.types." + typeName);
            }
            catch (Exception ex2) {
                log.warn((Object)("Can't find class for name " + typeName), (Throwable)ex2);
                clazz = String.class;
            }
        }
        return clazz;
    }

    public Object getValue(Class type, String valueId) {
        Object value = null;
        try {
            if (PopulationGroup.class.isAssignableFrom(type)) {
                int separatorIndex = valueId.indexOf(43);
                if (separatorIndex >= 0) {
                    String popName = valueId.substring(0, separatorIndex);
                    int groupId = Integer.parseInt(valueId.substring(separatorIndex + 1));
                    TopiaContext context = SimulationContext.get().getDB();
                    PopulationDAO populationDao = IsisFishDAOHelper.getPopulationDAO(context);
                    PopulationGroupDAO populationGroupDAO = IsisFishDAOHelper.getPopulationGroupDAO(context);
                    Object population = populationDao.findByName(popName);
                    value = populationGroupDAO.findByProperties("population", population, new Object[]{"id", groupId});
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"PopulationGroup identifiant doesn't contains '+' separator");
                    }
                    value = valueId;
                }
            } else if (TopiaEntity.class.isAssignableFrom(type)) {
                TopiaContext context = SimulationContext.get().getDB();
                Object dao = IsisFishDAOHelper.getDAO(context, type);
                value = dao.findByProperty("name", (Object)valueId);
            } else {
                value = ConverterUtil.getConverter(null).convert(valueId, type);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Can't get value for " + valueId), (Throwable)ex);
            value = valueId;
        }
        return value;
    }
}

