/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.util.ArgTypes;
import fr.ifremer.isisfish.util.Args;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class CompileHelper {
    private static final Log log = LogFactory.getLog(CompileHelper.class);

    public static List<File> searchSrcToCompile(File srcDir, File destDir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File src : srcDir.listFiles()) {
            File dest = new File(FileUtil.basename((File)src, (String[])new String[]{".java"}), ".class");
            if (!src.getName().endsWith(".java") || !FileUtils.isFileNewer((File)src, (File)dest)) continue;
            result.add(src);
        }
        return result;
    }

    public static Class<?> loadClass(String fqn) {
        Class<?> result = null;
        try {
            ClassLoader cl = IsisFish.config.getScriptClassLoader();
            result = cl.loadClass(fqn);
        }
        catch (ClassNotFoundException eee) {
            log.info((Object)I18n.t((String)"isisfish.error.load.class", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static Object newInstance(String fqn) {
        Object result = null;
        try {
            Class<?> clazz = CompileHelper.loadClass(fqn);
            if (clazz != null) {
                result = clazz.newInstance();
            }
        }
        catch (Exception eee) {
            log.warn((Object)I18n.t((String)"isisfish.error.instanciate", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static int compile(JavaSourceStorage source, File destDir, boolean force, PrintWriter out) {
        File src = source.getFile();
        File dst = new File(destDir, source.getFQN().replace('.', File.separatorChar) + ".class");
        if (force || !dst.exists() || FileUtils.isFileNewer((File)src, (File)dst)) {
            return CompileHelper.compile(source.getRoot(), src, destDir, out);
        }
        return 0;
    }

    public static int compile(File rootSrc, File src, File dest, PrintWriter out) {
        int result = CompileHelper.compile(rootSrc, Collections.singletonList(src), dest, out);
        return result;
    }

    public static int compile(File rootSrc, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block3: {
            result = -10000;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(rootSrc.getAbsoluteFile());
                for (File dir : CodeSourceStorage.Location.ALL.getDirectories()) {
                    classpath.add(dir);
                }
                result = CompileHelper.compile(classpath, src, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"Compilation failed", (Throwable)eee);
            }
        }
        return result;
    }

    protected static int compile(List<File> classpath, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block2: {
            dest.mkdirs();
            result = -1000;
            try {
                ArrayList<String> args = new ArrayList<String>();
                EclipseCompiler compiler = new EclipseCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(src);
                String classpathAsString = CompileHelper.getClassPathAsString(classpath);
                args.add("-source");
                args.add("1.7");
                args.add("-target");
                args.add("1.7");
                args.add("-g");
                args.add("-warn:deprecation");
                args.add("-encoding");
                args.add("utf-8");
                args.add("-classpath");
                args.add(classpathAsString);
                args.add("-d");
                args.add(dest.getAbsolutePath());
                boolean b = compiler.getTask(out, fileManager, null, args, null, compilationUnits).call();
                result = b ? 0 : -1;
                fileManager.close();
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't get compiler", (Throwable)eee);
            }
        }
        return result;
    }

    public static String getClassPathAsString(List<File> classpath) throws Exception {
        String[] systemClassPathes;
        String result = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            String jarName;
            URL url = e.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found manifest : " + url));
            }
            if (url == null || !url.getFile().startsWith("file:/") || result.contains(jarName = url.getPath().substring(5, url.getPath().indexOf("!")))) continue;
            result = result + File.pathSeparator + jarName;
        }
        String systemClassPath = System.getProperty("java.class.path");
        for (String path : systemClassPathes = systemClassPath.split(File.pathSeparator)) {
            String absolutePath = new File(path).getCanonicalPath();
            if (result.contains(absolutePath)) continue;
            result = result + File.pathSeparator + absolutePath;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLASSPATH : " + result));
        }
        return result;
    }

    public static String extractDoc(String category, String name, Class<?> javaInterface) {
        String content = "<p>Equation : " + CompileHelper.createHREF(javaInterface.getName(), category) + " - " + name + "</p>";
        content = content + "<h3>" + I18n.t((String)"isisfish.editor.parametersnameandtypes", (Object[])new Object[0]) + " :</h3>";
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        Args args = interfaceMethod.getAnnotation(Args.class);
        String[] names = args.value();
        String[] stringTypes = null;
        ArgTypes argTypes = interfaceMethod.getAnnotation(ArgTypes.class);
        if (argTypes != null) {
            stringTypes = argTypes.value();
        } else {
            stringTypes = new String[names.length];
            Object[] types = interfaceMethod.getParameterTypes();
            System.out.println(Arrays.toString(types));
            for (int i = 0; i < types.length; ++i) {
                stringTypes[i] = ((Class)types[i]).getName();
            }
        }
        for (int i = 0; i < names.length; ++i) {
            content = content + "<li>" + names[i] + " : " + CompileHelper.createHREF(stringTypes[i], new String[0]);
        }
        return content;
    }

    protected static String createHREF(String type, String ... texts) {
        String text = type;
        if (texts.length > 0) {
            text = texts[0];
        }
        String result = null;
        if (type.startsWith("fr.ifremer.isisfish")) {
            String ref = IsisFish.config.getJavadocURL() + type.replaceAll("\\.", "/") + ".html";
            result = "<a href='" + ref + "'>" + text + "</a>";
        } else {
            result = text;
        }
        return result;
    }
}

