/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.actions;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameterImpl;
import fr.ifremer.isisfish.simulator.launcher.InProcessSimulatorLauncher;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ZipUtil;

public class SimulationAction {
    private static Log log = LogFactory.getLog(SimulationAction.class);
    protected IsisConfig config = null;

    public SimulationAction(IsisConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulateWithRegion(String simulId, File parameterFile, File region) throws Exception {
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(parameterFile);){
            props.load(inStream);
        }
        SimulationParameterImpl params = new SimulationParameterImpl();
        params.fromProperties(props);
        String regionName = params.getRegionName();
        if (region != null) {
            if (!RegionStorage.exists(regionName)) {
                RegionStorage.importAndRenameZip(region, regionName);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)I18n.t((String)"Region %s allready exist in repository. Can't import", (Object[])new Object[]{regionName}));
            }
        }
        SimulationService.getService().submit(simulId, params, null, 0);
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void simulateWithSimulation(String simulationId, File simulationZip) throws Exception {
        SimulationAction.simulateWithSimulationAndScript(simulationId, simulationZip, null);
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void simulateWithSimulationAndScript(String simulationId, File simulationZip, File simulationPrescript) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Command line action : simulateWithSimulationAndScript (" + simulationId + ", " + simulationZip.getAbsolutePath() + ", " + simulationPrescript + ")"));
        }
        String name = simulationId;
        String generatedPrescriptContent = null;
        if (simulationPrescript != null && simulationPrescript.canRead()) {
            generatedPrescriptContent = FileUtils.readFileToString((File)simulationPrescript);
        }
        SimulationControl control = new SimulationControl(name);
        control.setAutoSaveState(true);
        SimulationItem item = new SimulationItem(control, null);
        item.setSimulationZip(simulationZip);
        item.setGeneratedPrescriptContent(generatedPrescriptContent);
        InProcessSimulatorLauncher launcher = new InProcessSimulatorLauncher();
        launcher.simulate(SimulationService.getService(), item);
        SimulationStorage simulation = launcher.getSimulationStorage(SimulationService.getService(), control);
        simulation.getStorage().closeContext();
        IsisFish.quit();
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void simulateRemotelly(String simulationId, File simulationZip, File simulationResultZip) throws Exception {
        SimulationAction.simulateRemotellyWithPreScript(simulationId, simulationZip, simulationResultZip, null);
    }

    @ApplicationConfig.Action.Step(value=1)
    public static void simulateRemotellyWithPreScript(String simulationId, File simulationZip, File simulationResultArchive, File simulationPrescript) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Command line action : simulateRemotelly");
            log.info((Object)(" simulation id : " + simulationId));
            log.info((Object)(" simulation zip : " + simulationZip));
            log.info((Object)(" result archive : " + simulationResultArchive));
            log.info((Object)(" prescript file : " + simulationPrescript));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timing : init isis simulation action : " + new Date()));
        }
        String name = simulationId;
        String generatedPrescriptContent = null;
        if (simulationPrescript != null && simulationPrescript.canRead()) {
            generatedPrescriptContent = FileUtils.readFileToString((File)simulationPrescript);
        }
        SimulationControl control = new SimulationControl(name);
        control.setAutoSaveState(true);
        SimulationItem item = new SimulationItem(control, null);
        item.setSimulationZip(simulationZip);
        item.setGeneratedPrescriptContent(generatedPrescriptContent);
        InProcessSimulatorLauncher launcher = new InProcessSimulatorLauncher();
        launcher.simulate(SimulationService.getService(), item);
        SimulationStorage simulationStorage = launcher.getSimulationStorage(SimulationService.getService(), control);
        if (log.isInfoEnabled()) {
            log.info((Object)("Compressing simulation as zip : " + simulationResultArchive));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Timing : before zipping results : " + new Date()));
            }
        }
        ZipUtil.compress((File)simulationResultArchive, (File)simulationStorage.getFile(), null, (boolean)true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timing : after zipping results : " + new Date()));
        }
        simulationStorage.closeStorage();
        if (log.isInfoEnabled()) {
            log.info((Object)("Deleting simulation : " + simulationStorage.getRoot()));
        }
        simulationStorage.delete(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Timing : end isis simulation action : " + new Date()));
        }
        IsisFish.quit();
    }
}

