package fr.ifremer.isisfish.ui.sensitivity.wizard;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.ui.input.InputOneEquationUI;
import fr.ifremer.isisfish.ui.sensitivity.model.FactorListModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n.t;

public class EquationContinuousPanelUI extends ContinuousPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_SELECTED_FACTOR = "selectedFactor";
    public static final String PROPERTY_TEXT = "text";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DISTRIBUTION_PANEL_ENABLED = "distributionPanel.enabled";
    public static final String BINDING_EDITOR_BEAN = "editor.bean";
    public static final String BINDING_EDITOR_BEAN_PROPERTY = "editor.beanProperty";
    public static final String BINDING_EDITOR_CLAZZ = "editor.clazz";
    public static final String BINDING_EDITOR_FORMULE = "editor.formule";
    public static final String BINDING_EDITOR_FORMULE_CATEGORY = "editor.formuleCategory";
    public static final String BINDING_EDITOR_SELECTED_EQUATION = "editor.selectedEquation";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWT28bRRSfuHVSJ2n+tiEVBQVwBQJpTEFClVKFtkkMDi6t4rQqNQfG3nEy0XpmOzPrrHNAfAQ+Aty5IHHjhDhw5sAF8RUQ4sAV8WZ2vet1Nq7Fqj7MWvPe+73fezPvvfnuT1RUEr12TIIAS59r1qV47+6TJw9ax7Std6hqS+ZpIVH4myqgQhPNOfG+0uiNZt2YVyLzyrboeoJTPmS9WUezSvddqo4o1Rq9krZoK1VpxOLNwPPlADUmlYX6zd9/Fb52vvq2gFDgAbtrEMrG86ySSC7WUYE5Gq2Apx6puIQfAg3J+CHwvWz2tl2i1KekS5+hL9FMHU17RAKYRq9PHrLFsPaBp9FyeVuADfeFrx4STt13NdruSMw6knYpfBVTHaaOsM+wolwxzXpM9/EJOyXSwbvPfKKZ4CMgj2qeZ31Ma3RR0wAYLhn+2MSEw5iGNFqUcI3eF/IQc59pwbEWHiPYoxLca8rbFB+YnV3wovvGGWCSlksTkHkD8lAKsNF9s7eQyIptl5yearSYcLBZSDQWO0J2fUgO0fRQyFGAJUVduH7UGcSr0Y2sJFHDj1EV5yWBmIk8aFQea1kN1RLDhYHvKmnDOcKRJVHcE8KFsIe9WCWoggWr5Wvm4jrkMFG5XN5rtKVwXXNScNovGcUAqxM4EzwkMuqlBLh8YPIN+uupCx2aWZnRvJHt5qbZfNMsbyU5jagadveFQ12Nbk1w8bpGFYe5iE2T6OaGUKNUxbGZPaP2Tqx9pWz2GjbBcFoWC0J8ddjsrIY3mhUb3tvp8CLRe7Hog1h0qbxXJy3raSVN0OwapVux7nKPSGaATNVXGXWhP6yljA6gFKxgxNAB3pK1fEPbFqVGu5MXdlLQO6M46WBK5b17voaahWhWU8TC7bT2BeJYnrvpZE0DJ9GjWRLqMHvrK+dwZ9zzNa6Z9QGng7p7VItgJHo5dV+hteOktSe9d6qJihLqDipnvXl2GuyDKJwD6yNzwABa6b9rq7/9+McP1UHzvwq+r2aqDs0uaMpe2LOYcb0Ydn5TtZX7xNtsolJY/bakr2cQa0RiIAf+lpOi/5ioI4Aozvz+089rX/x6ARWqaNYVJGojNVTSRxKyIFwn8D68YxnNn1yCdclwg8y7pC/gCNHCbYdostFi3IFz3QogCdczkhAzaZV++We18f2dQSKmgNi1c9WTZBSfomnGXcapnYPRiMuce3Oeor4jklGWNdymzHfWi6p1366PsyKdb1PX3afcoZJKo/VZ4JvPU0ve/PvcYt2cAKto+1NOkBnKTck7Y2A2J4CJJu/K7TCrG0SHhUy3/i+m2T4ew2orN8Ld3Ag7EyEIs3gvCuGj3FHUcnN4PgLUOPQCFvbdc1A+mQDlCvG1aJAehenIOqxtO3BOTPsmHJOfSTDOPAlzYIVPyJwggzdgTpisx2oOuDOP21x48bUcg/AfeH58teYNAAA=";
    private static final Log log = LogFactory.getLog(EquationContinuousPanelUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected ContinuousDistributionPanel distributionPanel;
    protected InputOneEquationUI editor;
    protected List<Factor> factors;
    protected JList<Factor> factorsList;
    protected FactorListModel factorsListModel;
    protected Formule formule;
    protected String formuleCategory;
    protected JButton remove;
    protected Equation selectedEquation;
    protected Boolean selectedFactor;
    protected String text;
    protected JTextField variableNameField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EquationContinuousPanelUI $ContinuousPanel0 = this;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void initWithFactor(Factor factor) {
        addFactor(factor);
    }
    
    protected void addFactor(Factor factor) {
        factors.add(factor);
        // fire data change
        factorsListModel.setFactors(factors);
    }
    
    /**
     * Valid selected factor.
     */
    protected void validSelectedFactor() {
        // fill selected
        Factor selectedFactor = (Factor)factorsList.getSelectedValue();
        selectedFactor.setEquationVariableName(variableNameField.getText().trim());
        selectedFactor.setDomain(distributionPanel.generateDomain());
    
        // parse equation content to replace
        // double xxx = 4.0;
        // by
        // double xxx = context.getValueAndCompute("myfactorname.xxx", 4.0)
        // if xxx is the variable name to replace
        FactorWizardUI wizard = getParentContainer(FactorWizardUI.class);
        String factorName = wizard.getFactorNameField().getText().trim();
        String variableName = selectedFactor.getEquationVariableName();
        String[] lines = editor.getEditor().getText().split("\n");
        String result = "";
        for (String line : lines) {
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(line);
            if (matcher.find()) {
                String fullVariableName = factorName + "." + variableName;
                line = matcher.group(1) +  "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result += line + "\n";
        }
        editor.getEditor().setText(result);
        
        // fire data change
        factorsListModel.setFactors(factors);
    }
    
    protected void addNewVariable() {
        Factor factor = new Factor("");
        factor.setEquationVariableName("X");
        addFactor(factor);
        
        // auto select
        factorsList.setSelectedValue(factor, true);
    }
    
    protected void displaySelectedFactor() {
        Factor selectedFactor = (Factor)factorsList.getSelectedValue();
        variableNameField.setText(selectedFactor.getEquationVariableName());
        distributionPanel.initWithFactor(selectedFactor);
    }
    
    protected void removeSelectedVariable() {
        int selectedIndex = factorsList.getSelectedIndex();
        factors.remove(selectedIndex);
        
        // fire data change
        factorsList.clearSelection();
        factorsListModel.setFactors(factors);
    }
    
    @Override
    public boolean isFactorValid() {
        boolean valid = true;
    
        for (Factor factor : factors) {
            if (StringUtils.isBlank(factor.getEquationVariableName())) {
                valid = false;
            }
            if (factor.getDomain() == null) {
                valid = false;
            }
        }
        
        return valid;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EquationContinuousPanelUI() {
        $initialize();
    }

    public EquationContinuousPanelUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSelectedFactor();
    }

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        addNewVariable();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectedVariable();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        displaySelectedFactor();setSelectedFactor(factorsList.getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class getClazz() {
        return clazz;
    }

    public ContinuousDistributionPanel getDistributionPanel() {
        return distributionPanel;
    }

    public InputOneEquationUI getEditor() {
        return editor;
    }

    public List<Factor> getFactors() {
        return factors;
    }

    public JList<Factor> getFactorsList() {
        return factorsList;
    }

    public FactorListModel getFactorsListModel() {
        return factorsListModel;
    }

    public Formule getFormule() {
        return formule;
    }

    public String getFormuleCategory() {
        return formuleCategory;
    }

    public JButton getRemove() {
        return remove;
    }

    public Equation getSelectedEquation() {
        return selectedEquation;
    }

    public Boolean getSelectedFactor() {
        return selectedFactor;
    }

    public String getText() {
        return text;
    }

    public JTextField getVariableNameField() {
        return variableNameField;
    }

    public Boolean isSelectedFactor() {
        return selectedFactor !=null && selectedFactor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setSelectedFactor(Boolean selectedFactor) {
        Boolean oldValue = this.selectedFactor;
        this.selectedFactor = selectedFactor;
        firePropertyChange(PROPERTY_SELECTED_FACTOR, oldValue, selectedFactor);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanProperty() {
        $objectMap.put("beanProperty", beanProperty = null);
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createDistributionPanel() {
        $objectMap.put("distributionPanel", distributionPanel = new ContinuousDistributionPanel(0.0d));
        
        distributionPanel.setName("distributionPanel");
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new InputOneEquationUI(this));
        
        editor.setName("editor");
        editor.setActive(true);
        editor.setAutoSaveModification(false);
    }

    protected void createFactors() {
        $objectMap.put("factors", factors = new ArrayList<Factor>());
    }

    protected void createFactorsList() {
        $objectMap.put("factorsList", factorsList = new JList<Factor>());
        
        factorsList.setName("factorsList");
    }

    protected void createFactorsListModel() {
        $objectMap.put("factorsListModel", factorsListModel = new FactorListModel(factors));
    }

    protected void createFormule() {
        $objectMap.put("formule", formule = null);
    }

    protected void createFormuleCategory() {
        $objectMap.put("formuleCategory", formuleCategory = null);
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createSelectedEquation() {
        $objectMap.put("selectedEquation", selectedEquation = null);
    }

    protected void createSelectedFactor() {
        $objectMap.put("selectedFactor", selectedFactor = false);
    }

    protected void createText() {
        $objectMap.put("text", text = null);
    }

    protected void createVariableNameField() {
        $objectMap.put("variableNameField", variableNameField = new JTextField());
        
        variableNameField.setName("variableNameField");
        variableNameField.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $ContinuousPanel0
        add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(factorsList);
        // inline complete setup of $Table1
        $Table1.add($Table2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(distributionPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        factorsList.setCellRenderer(new fr.ifremer.isisfish.ui.sensitivity.model.FactorListRenderer());
        factorsList.setModel(factorsListModel);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$ContinuousPanel0", $ContinuousPanel0);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormuleCategory();
        createSelectedEquation();
        createFormule();
        createSelectedFactor();
        createFactors();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createFactorsListModel();
        createFactorsList();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = factorsList.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.sensitivity.equation.variablename"));
        createVariableNameField();
        createDistributionPanel();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.sensitivity.equation.valid"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdd();
        createRemove();
        createEditor();
        // inline creation of $ContinuousPanel0
        setName("$ContinuousPanel0");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                variableNameField.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DISTRIBUTION_PANEL_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                distributionPanel.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"selectedFactor") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isSelectedFactor());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                editor.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_BEAN_PROPERTY, true ,"beanProperty") {
        
            @Override
            public void processDataBinding() {
                editor.setBeanProperty(getBeanProperty());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_CLAZZ, true ,"clazz") {
        
            @Override
            public void processDataBinding() {
                editor.setClazz(getClazz());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE, true ,"formule") {
        
            @Override
            public void processDataBinding() {
                editor.setFormule(getFormule());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_FORMULE_CATEGORY, true ,"formuleCategory") {
        
            @Override
            public void processDataBinding() {
                editor.setFormuleCategory(getFormuleCategory());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_SELECTED_EQUATION, true ,"selectedEquation") {
        
            @Override
            public void processDataBinding() {
                editor.setSelectedEquation(getSelectedEquation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                editor.setText(t(getText()));
            }
        });
    }

}