package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.model.PopulationSeasonInfoComboModel;
import fr.ifremer.isisfish.ui.widget.Interval;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationSeasonsUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION_SEASON_INFO = "populationSeasonInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_COMMENT_ENABLED = "fieldPopulationSeasonComment.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_COMMENT_TEXT = "fieldPopulationSeasonComment.text";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_ENABLED = "fieldPopulationSeasonGroupChange.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_SELECTED = "fieldPopulationSeasonGroupChange.selected";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_VISIBLE = "fieldPopulationSeasonGroupChange.visible";
    public static final String BINDING_FIELD_POPULATION_SEASON_INFO_CHOOSER_ENABLED = "fieldPopulationSeasonInfoChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_ENABLED = "fieldPopulationSeasonReproductionDistribution.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_MATRIX = "fieldPopulationSeasonReproductionDistribution.matrix";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_VISIBLE = "fieldPopulationSeasonReproductionDistribution.visible";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_ENABLED = "fieldPopulationSeasonReproduction.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_SELECTED = "fieldPopulationSeasonReproduction.selected";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_AGE_GROUP_TYPE = "populationSeasonSpecializedUI.ageGroupType";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_BEAN = "populationSeasonSpecializedUI.bean";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_POPULATION_SEASON_INFO = "populationSeasonSpecializedUI.populationSeasonInfo";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SEASON_INTERVAL_PANEL_ENABLED = "seasonIntervalPanel.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_SEASON_BEAN = "validatorSeason.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL2_VISIBLE = "$JLabel2.visible";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzXPbRBTfmMROmpYW3JYwJEPamhaGIictw4GUfsQlxRmHljphCh5mupbW9hZZu91dJQoHhj+hV25w58IMN04MB84cuDD9FxiGA1eGtyvbshxVFsiHlbzvvd/7vY/dp+/+QHNSoHOPcBBYwvcU7RNr+9aDB3fbj4itbhNpC8oVEyj8zRRQoYUWndG+VOhCq6HNqwPzao31OfOIN2a90UDHpDp0iewRohRaiVvYUlabI/FGwH0xRB2RSkL95q8/C0+cr74tIBRwYLcCoaxOs4oimW2gAnUUehE87eOqi70u0BDU6wLfE3qv5mIpP8R98hh9iUoNVORYAJhC57OHbDCMfcAVOlWpe9xXNeYpUN+rrym01hEW7QjSJ/CUVHao7Fk+tahWtO4x7rtYUeY1CZbMk3t1zg1eUaHZNsGeQpeSEACeKkrkGEJkeJpPwNa9DlNoPSNQZBNBLuxjlzoYQlfozVgRRgJLHkByraZePx5uRggnR4ohvt4+HYkX7R5UiOwwh7gKvZ6atVqkGgGUK01TnLoH8YCrL4iA9F80XG2oIHUBK6yfdURzPOnMOYSu0Q0SDELavoe9cVelyi5uuwTgl2KpCLWNTGuuTBqs67/n9bI6Es1Xthu4Tdy1SZ9mVytdGOmudihxnaRC1XqMSQK1ORPDgM5ts00WxGGGLg2dS3FZWQ4wFRFQMBM4VPwZ5TigTpcoK6Z9xJfZXdP/X80Szh3BfB5W+Eg4PWJ/fiSclclub3Jih3V19uoKvfufTmCT48g4OZb1hFjOJcZyn3DBHN/WO1rx7eRCXEkoxFtTAW9TCddZ29fvCl1momt5PlXMs/pY9fQiaGB1IdId82q4v++AhkimcTWBxonKNhwW5praQo++FCtIJIpbLSeSh27sm/s1XtVdEqhbgmBtW5s8MlcSjsysxPvQG+UYyqavVJjk+kixaGPPDjtyZ1ICDhVJksClQuISgV6JHXMYaFY00KKJM9NCc8KHbbgXWkdn4H0QhdNvaWL6aUAj/eds+bcfn/6wNRx5r4HvM4mqYxMbRhE0BYfTT7Xrk+G8g7ZwqzuYb7TQgoSQ7HCcLycQaw7EQA78vaDNLW1ufYBlDyDmSr//9PPZh78+hwpb6JjLsLOFtX4dLaiegCww1wn4jZuG0fGDeVhPaW5QxPBShyn8/DW4+vFqm3oOlOt6AFlYTsjCiEp74Ze/y83vbw4zMQPMXn6mepSNuU9RkXou9YgZ/4PJnjjuF7kkvsOiCZ4002f0c4kP7v5PzPpZUqhzZrxp8cPA1w9sWOs3OzNIiXi66dNgLmaAmVVwpGCeXAszsYpVeFGQ6/8XU2+7KazeyMBqHj6uHCKIyIUzjcnlTAiP9SLyIKRxsHIjXM2Sz/BYp3bLdJxp2cjCpLQPc3Xw0ZMjoOO4S8z03z3kaVjvZDkC+ts5J0biZ3QuzGll38iE8CQ3QlrBsyGkRfFebg7ZEL7OzSEtihsZOqQYfmTlQpkWSTaEtEg2c9cjG0IahzvZOeRCSOPQyJ2HbAhpHO7m5pANIY3DR7k5ZENI49DMzUEj/AvVOIOU4RIAAA==";
    private static final Log log = LogFactory.getLog(PopulationSeasonsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldPopulationSeasonComment;
    protected JCheckBox fieldPopulationSeasonGroupChange;
    protected JComboBox fieldPopulationSeasonInfoChooser;
    protected JCheckBox fieldPopulationSeasonReproduction;
    protected MatrixPanelEditor fieldPopulationSeasonReproductionDistribution;
    protected PopulationSeasonInfo populationSeasonInfo;
    protected PopulationSeasonSpacializedUI populationSeasonSpecializedUI;
    protected JButton save;
    protected IntervalPanel seasonIntervalPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSeason")
    protected SwingValidator<PopulationSeasonInfo> validatorSeason;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationSeasonsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Interval seasonInterval;
    protected boolean init;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    fieldPopulationSeasonComment.setText("");
                    fieldPopulationSeasonReproductionDistribution.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    refresh();
                }
            }
        });
        
        /*
         * Don't add both in same listener.
         * When first is set, last value from getPopulationSeasonInfo()
         * is erased by interval.getLast() default value.
         */
        seasonIntervalPanel.addPropertyChangeListener("first", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().setFirstMonth(new Month(seasonInterval.getFirst()));
                    setReproductionDistributionMatrix();
                }
            }
        });
        seasonIntervalPanel.addPropertyChangeListener("last", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().setLastMonth(new Month(seasonInterval.getLast()));
                    setReproductionDistributionMatrix();
                }
            }
        });
    }
    
    @Override
    public void resetChangeModel() {
        changeModel.setStayChanged(false);
    }
    
    protected void create() {
        PopulationSeasonInfo seasonNew = getContextValue(InputAction.class).createPopulationSeasonInfo(getBean());
        setPopulationSeasonInfo(seasonNew);
        setPopulationSeasonInfoCombo();
    }
    
    protected void delete() {
        getContextValue(InputAction.class).removePopulationSeasonInfo(getBean(), getPopulationSeasonInfo());
        setPopulationSeasonInfo(null);
        setPopulationSeasonInfoCombo();
    }
    
    protected void save() {
        getSaveVerifier().save();
        setPopulationSeasonInfoCombo();
    }
    
    protected void populationSeasonReproductionDistributionMatrixChanged(MatrixPanelEvent event) {
        if (getPopulationSeasonInfo() != null && fieldPopulationSeasonReproductionDistribution.getMatrix() != null) {
            MatrixND reproductionDistribution = fieldPopulationSeasonReproductionDistribution.getMatrix().copy();
            if (log.isDebugEnabled()) {
                log.debug("Matrix ReproductionDistribution modified : " + reproductionDistribution);
            }
            getPopulationSeasonInfo().setReproductionDistribution(reproductionDistribution);
        }
    }
    
    public void refresh() {
        Population population = getSaveVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        //setBean(null);
        //setBean(population);
    
        setPopulationSeasonInfo(null);
    
        // Model instanciation
        seasonInterval = new Interval();
        seasonInterval.setMin(0);
        seasonInterval.setMax(11);
        seasonInterval.setFirst(0);
        seasonInterval.setLast(2);
    
        setPopulationSeasonInfoCombo();
        setSeasonInterval();
    
        seasonIntervalPanel.setLabelRenderer(Month.MONTH);
        seasonIntervalPanel.setModel(seasonInterval);
    
        //fieldPopulationSeasonReproductionDistribution.addMatrixListener(matrixPanelListener);
    
        /*if(getPopulationSeasonInfo() != null) {
            PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
            setPopulationSeasonInfo(null);
            setPopulationSeasonInfo(popInfo);
            getSaveVerifier().addCurrentEntity(getPopulationSeasonInfo());
        }*/
        //getSaveVerifier().addCurrentPanel(populationSeasonSpecializedUI);
    }
    
    protected void setSeasonInterval() {
        if(getPopulationSeasonInfo() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Updating interval : ");
                }
                Month firstMonth = getPopulationSeasonInfo().getFirstMonth();
    
                if (firstMonth != null) {
                    seasonInterval.setFirst(firstMonth.getMonthNumber());
                    
                    if (log.isDebugEnabled()) {
                        log.debug(" first : " + seasonInterval.getFirst());
                    }
                } else {
                    seasonInterval.setFirst(0);
                }
    
                Month lastMonth = getPopulationSeasonInfo().getLastMonth();
                if (lastMonth != null) {
                    seasonInterval.setLast(lastMonth.getMonthNumber());
                    if (log.isDebugEnabled()) {
                        log.debug(" last : " + seasonInterval.getLast());
                    }
                } else {
                    seasonInterval.setLast(3);
                }
            } catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't display interval", e);
                }
            }
        }
    }
    
    protected void setPopulationSeasonInfoCombo() {
        if (getBean() != null) {
            PopulationSeasonInfoComboModel populationSeasonInfoModel = new PopulationSeasonInfoComboModel(getBean().getPopulationSeasonInfo());
            fieldPopulationSeasonInfoChooser.setModel(populationSeasonInfoModel);
            populationSeasonInfoModel.setSelectedItem(getPopulationSeasonInfo());
        }
    }
    
    protected void seasonGroupChanged() {
        if (getPopulationSeasonInfo() != null) {
           getPopulationSeasonInfo().setGroupChange(fieldPopulationSeasonGroupChange.isSelected());
        }
    }
    
    protected void seasonChanged() {
        init = true;
        PopulationSeasonInfo seasonInfoSelected = (PopulationSeasonInfo)fieldPopulationSeasonInfoChooser.getSelectedItem();
        if (log.isDebugEnabled()) {
            log.debug("Season changed : " + seasonInfoSelected);
        }
        setPopulationSeasonInfo(seasonInfoSelected);
        if (seasonInfoSelected != null) {
            getSaveVerifier().addCurrentEntity(seasonInfoSelected);
        }
        setSeasonInterval();
        setReproductionDistributionMatrix();
        init = false;
    }
    
    protected void setReproductionDistributionMatrix() {
        if (getPopulationSeasonInfo() != null){
            MatrixND reproductionDistribution = getPopulationSeasonInfo().getReproductionDistribution();
            // must be a copy (otherwise, modify current entity matrix)
            if (reproductionDistribution != null){
                fieldPopulationSeasonReproductionDistribution.setMatrix(reproductionDistribution.copy());
            }
        }
    }
    
    // TODO une methode isXXX ne prend pas de parametre
    // et ne fait rien
    protected boolean isAgeGroupType(boolean result) {
        populationSeasonSpecializedUI.setVisible(result);
        return result;
    }
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        populationSeasonSpecializedUI.setLayer(active);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationSeasonsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationSeasonsUI() {
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        delete();
    }

    public void doActionPerformed__on__fieldPopulationSeasonGroupChange(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        seasonGroupChanged();
    }

    public void doActionPerformed__on__fieldPopulationSeasonReproduction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getPopulationSeasonInfo().setReproduction(fieldPopulationSeasonReproduction.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        save();validator.setChanged(false);validatorSeason.setChanged(false);
    }

    public void doItemStateChanged__on__fieldPopulationSeasonInfoChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        seasonChanged();
    }

    public void doKeyReleased__on__fieldPopulationSeasonComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setSeasonsComment(fieldPopulationSeasonComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        populationSeasonReproductionDistributionMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldPopulationSeasonComment() {
        return fieldPopulationSeasonComment;
    }

    public JCheckBox getFieldPopulationSeasonGroupChange() {
        return fieldPopulationSeasonGroupChange;
    }

    public JComboBox getFieldPopulationSeasonInfoChooser() {
        return fieldPopulationSeasonInfoChooser;
    }

    public JCheckBox getFieldPopulationSeasonReproduction() {
        return fieldPopulationSeasonReproduction;
    }

    public MatrixPanelEditor getFieldPopulationSeasonReproductionDistribution() {
        return fieldPopulationSeasonReproductionDistribution;
    }

    public PopulationSeasonInfo getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    public PopulationSeasonSpacializedUI getPopulationSeasonSpecializedUI() {
        return populationSeasonSpecializedUI;
    }

    public JButton getSave() {
        return save;
    }

    public IntervalPanel getSeasonIntervalPanel() {
        return seasonIntervalPanel;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    public SwingValidator<PopulationSeasonInfo> getValidatorSeason() {
        return validatorSeason;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {
        PopulationSeasonInfo oldValue = this.populationSeasonInfo;
        this.populationSeasonInfo = populationSeasonInfo;
        firePropertyChange(PROPERTY_POPULATION_SEASON_INFO, oldValue, populationSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorSeason() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSeason.setUiClass(ImageValidationUI.class);
        validatorSeason.setParentValidator(getValidator());
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldPopulationSeasonComment() {
        $objectMap.put("fieldPopulationSeasonComment", fieldPopulationSeasonComment = new JTextArea());
        
        fieldPopulationSeasonComment.setName("fieldPopulationSeasonComment");
        fieldPopulationSeasonComment.setColumns(15);
        fieldPopulationSeasonComment.setLineWrap(true);
        fieldPopulationSeasonComment.setWrapStyleWord(true);
        fieldPopulationSeasonComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationSeasonComment"));
    }

    protected void createFieldPopulationSeasonGroupChange() {
        $objectMap.put("fieldPopulationSeasonGroupChange", fieldPopulationSeasonGroupChange = new JCheckBox());
        
        fieldPopulationSeasonGroupChange.setName("fieldPopulationSeasonGroupChange");
        fieldPopulationSeasonGroupChange.setText(t("isisfish.populationSeasons.changeGroup"));
        fieldPopulationSeasonGroupChange.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationSeasonGroupChange"));
        fieldPopulationSeasonGroupChange.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        fieldPopulationSeasonGroupChange.putClientProperty("sensitivityMethod", "GroupChange");
    }

    protected void createFieldPopulationSeasonInfoChooser() {
        $objectMap.put("fieldPopulationSeasonInfoChooser", fieldPopulationSeasonInfoChooser = new JComboBox());
        
        fieldPopulationSeasonInfoChooser.setName("fieldPopulationSeasonInfoChooser");
        fieldPopulationSeasonInfoChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationSeasonInfoChooser"));
    }

    protected void createFieldPopulationSeasonReproduction() {
        $objectMap.put("fieldPopulationSeasonReproduction", fieldPopulationSeasonReproduction = new JCheckBox());
        
        fieldPopulationSeasonReproduction.setName("fieldPopulationSeasonReproduction");
        fieldPopulationSeasonReproduction.setText(t("isisfish.populationSeasons.Reproduction"));
        fieldPopulationSeasonReproduction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationSeasonReproduction"));
    }

    protected void createFieldPopulationSeasonReproductionDistribution() {
        $objectMap.put("fieldPopulationSeasonReproductionDistribution", fieldPopulationSeasonReproductionDistribution = new MatrixPanelEditor());
        
        fieldPopulationSeasonReproductionDistribution.setName("fieldPopulationSeasonReproductionDistribution");
        fieldPopulationSeasonReproductionDistribution.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution"));
        fieldPopulationSeasonReproductionDistribution.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        fieldPopulationSeasonReproductionDistribution.putClientProperty("sensitivityMethod", "ReproductionDistribution");
    }

    protected void createPopulationSeasonInfo() {
        $objectMap.put("populationSeasonInfo", populationSeasonInfo = null);
    }

    protected void createPopulationSeasonSpecializedUI() {
        $objectMap.put("populationSeasonSpecializedUI", populationSeasonSpecializedUI = new PopulationSeasonSpacializedUI(this));
        
        populationSeasonSpecializedUI.setName("populationSeasonSpecializedUI");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSeasonIntervalPanel() {
        $objectMap.put("seasonIntervalPanel", seasonIntervalPanel = new IntervalPanel());
        
        seasonIntervalPanel.setName("seasonIntervalPanel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "seasons"));
    }

    protected void createValidatorSeason() {
        $objectMap.put("validatorSeason", validatorSeason = SwingValidator.newValidator(PopulationSeasonInfo.class, "population"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorSeason();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldPopulationSeasonInfoChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(seasonIntervalPanel), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonGroupChange), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(populationSeasonSpecializedUI, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonReproduction), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonReproductionDistribution), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 28 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldPopulationSeasonInfoChooser.setRenderer(new fr.ifremer.isisfish.ui.input.renderer.PopulationSeasonInfoComboRenderer());
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulationSeasonInfo();
        createValidator();
        createValidatorSeason();
        createChangeModel();
        init = false;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationSeasons.selectSeason"));
        createFieldPopulationSeasonInfoChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.common.season"));
        createSeasonIntervalPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFieldPopulationSeasonGroupChange();
        createPopulationSeasonSpecializedUI();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createFieldPopulationSeasonReproduction();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationSeasons.distributionSpawning"));
        createFieldPopulationSeasonReproductionDistribution();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationSeasons.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationSeasonComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 28 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 28 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_SEASON_BEAN, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validatorSeason.setBean(getPopulationSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setChanged(validator.isChanged() || validatorSeason.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setValid(validator.isValid() && validatorSeason.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_INFO_CHOOSER_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    fieldPopulationSeasonInfoChooser.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SEASON_INTERVAL_PANEL_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                seasonIntervalPanel.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonGroupChange.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("groupChange", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonGroupChange.setSelected(getPopulationSeasonInfo().getGroupChange());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("groupChange", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("population", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getPopulation() != null && getPopulationSeasonInfo().getPopulation().getSpecies() != null) {
                    fieldPopulationSeasonGroupChange.setVisible(isAgeGroupType(getPopulationSeasonInfo().getPopulation().getSpecies().getAgeGroupType()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("population", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_AGE_GROUP_TYPE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("population", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getPopulation() != null && getPopulationSeasonInfo().getPopulation().getSpecies() != null) {
                    populationSeasonSpecializedUI.setAgeGroupType(isAgeGroupType(!getPopulationSeasonInfo().getPopulation().getSpecies().getAgeGroupType()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("population", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationSeasonSpecializedUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_POPULATION_SEASON_INFO, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                populationSeasonSpecializedUI.setPopulationSeasonInfo(getPopulationSeasonInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonReproduction.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonReproduction.setSelected(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    $JLabel2.setVisible(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonReproductionDistribution.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproductionDistribution", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getReproductionDistribution() != null) {
                    fieldPopulationSeasonReproductionDistribution.setMatrix(getPopulationSeasonInfo() == null ? null : getPopulationSeasonInfo().getReproductionDistribution().copy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproductionDistribution", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonReproductionDistribution.setVisible(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_COMMENT_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonComment.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationSeasonComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getSeasonsComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    create.setEnabled(!changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
    }

}