/*
 * #%L
 * $Id: GraphAction.java 1033 2012-08-09 10:36:21Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4/coser-web/src/main/java/fr/ifremer/coser/web/actions/pop/GraphAction.java $
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.pop;

import java.util.Locale;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Affiche le graphique demandé.
 * 
 * Parametre : zone, species, indicator.
 *  
 * @author chatellier
 * @version $Revision: 1033 $
 * 
 * Last update : $Date: 2012-08-09 12:36:21 +0200 (Thu, 09 Aug 2012) $
 * By : $Author: echatellier $
 */
public class GraphAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    protected String facade;

    protected String zone;
    
    protected String species;
    
    protected String indicator;

    public String getFacade() {
        return facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSpecies() {
        return species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getIndicator() {
        return indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getFacades().get(facade);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getZoneForFacade(facade, false, false).get(zone);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", ex);
        }
        return displayName;
    }
    
    public String getSpeciesDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getSpecies(zone, false).get(species);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }
    
    public String getIndicatorDisplayName() {
        
        Locale locale = getLocale();

        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = webService.getIndicators(zone, species, locale).get(indicator);
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", ex);
        }
        return displayName;
    }

    @Override
    public String execute() {
        return SUCCESS;
    }
}
