/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.search;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.util.DataType;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.ServletRequestAware;

@InterceptorRefs(value={@InterceptorRef(value="defaultStack"), @InterceptorRef(value="execAndWait", params={"excludeMethods", "execute,quality"})})
public class ExtractAction
extends CoserAction
implements ServletRequestAware {
    private static final long serialVersionUID = 8497086194191374797L;
    private static final Log log = LogFactory.getLog(ExtractAction.class);
    protected Map<String, String> zones;
    protected List<String> selectZones;
    protected List<DataType> selectTypes;
    protected Map<String, String> species;
    protected List<String> selectSpecies;
    protected Map<String, String> comIndicators;
    protected List<String> selectComIndicators;
    protected Map<String, String> popIndicators;
    protected List<String> selectPopIndicators;
    protected String submitAction;
    protected boolean accepted;
    protected HttpServletRequest request;
    protected File zipFile;

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String execute() {
        String result;
        if (StringUtils.isNotBlank((CharSequence)this.submitAction)) {
            result = "success";
        } else {
            result = "input";
            Locale locale = this.getLocale();
            WebService webService = ServiceFactory.getWebService();
            try {
                this.zones = webService.getZoneForFacade(null, false, false);
                if (CollectionUtils.isNotEmpty((Collection)this.selectZones)) {
                    this.species = webService.getSpecies((Collection)this.selectZones, false);
                    if (this.selectTypes != null && this.selectTypes.contains(DataType.COMMUNITY)) {
                        this.comIndicators = webService.getIndicators((Collection)this.selectZones, DataType.COMMUNITY, locale);
                    }
                    if (this.selectTypes != null && this.selectTypes.contains(DataType.POPULATION)) {
                        this.popIndicators = webService.getIndicators((Collection)this.selectZones, DataType.POPULATION, locale);
                    }
                }
            }
            catch (CoserBusinessException ex) {
                throw new CoserWebException("Can't get zone map", (Throwable)ex);
            }
        }
        return result;
    }

    public Map<String, String> getZones() {
        return this.zones;
    }

    public List<String> getSelectZones() {
        return this.selectZones;
    }

    public void setSelectZones(List<String> selectZones) {
        this.selectZones = selectZones;
    }

    public List<DataType> getSelectTypes() {
        return this.selectTypes;
    }

    public void setSelectTypes(List<DataType> selectTypes) {
        this.selectTypes = selectTypes;
    }

    public List<String> getSelectSpecies() {
        return this.selectSpecies;
    }

    public void setSelectSpecies(List<String> selectSpecies) {
        this.selectSpecies = selectSpecies;
    }

    public List<String> getSelectComIndicators() {
        return this.selectComIndicators;
    }

    public void setSelectComIndicators(List<String> selectComIndicators) {
        this.selectComIndicators = selectComIndicators;
    }

    public List<String> getSelectPopIndicators() {
        return this.selectPopIndicators;
    }

    public void setSelectPopIndicators(List<String> selectPopIndicators) {
        this.selectPopIndicators = selectPopIndicators;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public Map<String, String> getComIndicators() {
        return this.comIndicators;
    }

    public Map<String, String> getPopIndicators() {
        return this.popIndicators;
    }

    public void setSubmitAction(String submitAction) {
        this.submitAction = submitAction;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    @Action(value="extract-quality", results={@Result(location="/WEB-INF/content/search/extract-success.jsp"), @Result(name="download", type="redirect", params={"location", "${location}"})})
    public String quality() {
        String result;
        if (!this.accepted) {
            this.addFieldError("accepted", this.getText("message.quality.notaccepted"));
            result = "success";
        } else {
            this.request.getSession().setAttribute("locale", (Object)this.getLocale());
            result = "download";
        }
        return result;
    }

    public String getLocation() {
        String url = "extract-download?accepted=true";
        if (this.selectZones != null) {
            for (String zone : this.selectZones) {
                url = url + "&selectZones=" + zone;
            }
        }
        if (this.selectTypes != null) {
            for (DataType type : this.selectTypes) {
                url = url + "&selectTypes=" + type;
            }
        }
        if (this.selectSpecies != null) {
            for (String species : this.selectSpecies) {
                url = url + "&selectSpecies=" + species;
            }
        }
        if (this.selectComIndicators != null) {
            for (String selectComIndicator : this.selectComIndicators) {
                url = url + "&selectComIndicators=" + selectComIndicator;
            }
        }
        if (this.selectPopIndicators != null) {
            for (String selectPopIndicator : this.selectPopIndicators) {
                url = url + "&selectPopIndicators=" + selectPopIndicator;
            }
        }
        return url;
    }

    @Action(value="extract-download", results={@Result(name="wait", location="/WEB-INF/content/search/extract-wait.jsp"), @Result(type="stream", params={"contentType", "application/zip", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String download() {
        try {
            Locale locale = (Locale)this.request.getSession().getAttribute("locale");
            WebService webService = ServiceFactory.getWebService();
            this.zipFile = webService.extractData(this.selectZones, this.selectTypes, this.selectSpecies, this.selectComIndicators, this.selectPopIndicators, locale);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't extract data", (Throwable)ex);
            }
            throw new CoserWebException("Can't extract data", (Throwable)ex);
        }
        return "success";
    }

    public InputStream getInputStream() {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.zipFile);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't extract data", (Throwable)ex);
            }
            throw new CoserWebException("Can't extract data", (Throwable)ex);
        }
        return is;
    }

    public String getFilename() {
        return "Indicateurs_Ifremer.zip";
    }
}

