/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.common;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommonIndicator
extends CoserAction {
    private static final long serialVersionUID = 1663244944108703571L;
    private static final Log log = LogFactory.getLog(CommonIndicator.class);
    protected String facade;
    protected String zone;
    protected String species;
    protected String zonePicture;
    protected Map<String, String> indicators;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public Map<String, String> getIndicators() {
        return this.indicators;
    }

    public String getZonePicture() {
        return this.zonePicture;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get facade display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getZoneDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getZoneForFacade(this.facade, false).get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone display name", (Throwable)ex);
        }
        return displayName;
    }

    public String getSpeciesDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getSpecies(this.zone).get(this.species);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Looking for indicator for zone %s and species %s", this.zone, this.species));
        }
        WebService webService = ServiceFactory.getWebService();
        Locale locale = this.getLocale();
        String localeCode = locale.getLanguage();
        try {
            this.indicators = webService.getIndicators(this.zone, this.species, localeCode);
            this.zonePicture = (String)webService.getZonePictures().get(this.zone);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get indicators", (Throwable)ex);
        }
        return "success";
    }
}

