package fr.ifremer.coser.ui.selection.replay;

/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2013 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.ui.selection.model.SpeciesListModel;
import fr.ifremer.coser.ui.selection.model.SpeciesTypesListModel;
import fr.ifremer.coser.ui.selection.model.StrataListModel;
import fr.ifremer.coser.ui.selection.model.YearListModel;
import fr.ifremer.coser.ui.util.CoserListSelectionModel;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectionReplayView extends JDialog implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REPLAYED_SELECTION = "replayedSelection";
    public static final String PROPERTY_SELECTION = "selection";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DETAILS_COMMENT_TEXT = "detailsComment.text";
    public static final String BINDING_DETAILS_DESCRIPTION_TEXT = "detailsDescription.text";
    public static final String BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT = "detailsSelectionNameField.text";
    public static final String BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL = "selectedSpeciesList.selectionModel";
    public static final String BINDING_STRATA_LIST_SELECTION_MODEL = "strataList.selectionModel";
    public static final String BINDING_YEARS_LIST_SELECTION_MODEL = "yearsList.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON3_ENABLED = "$JButton3.enabled";
    private static final String BINDING_$JBUTTON5_ENABLED = "$JButton5.enabled";
    private static final String BINDING_$JBUTTON7_ENABLED = "$JButton7.enabled";
    private static final String BINDING_$JBUTTON9_ENABLED = "$JButton9.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(SelectionReplayView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JList commandList;
    protected CommandListModel commandListModel;
    protected JTextArea detailsComment;
    protected JTextArea detailsDescription;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "description",  editorName = "detailsDescriptionSP")
    protected JScrollPane detailsDescriptionSP;
    @ValidatorField( validatorId = "validatorSelection",  propertyName = "name",  editorName = "detailsSelectionNameField")
    protected JTextField detailsSelectionNameField;
    protected SwingValidatorMessageTableModel errorsTableModel;
    protected SelectionReplayHandler handler;
    protected JTextArea messageArea1;
    protected JTextArea messageArea2;
    protected JTextArea messageArea3;
    protected JTextArea messageArea4;
    protected JTextArea messageArea5;
    protected Selection replayedSelection;
    protected JList selectedSpeciesList;
    protected SpeciesListModel selectedSpeciesListModel;
    protected Selection selection;
    protected JTree selectionByProjectTree;
    protected JList strataList;
    protected StrataListModel strataListModel;
    protected JButton validCommandButton;
    protected JButton validSelectionButton;
    protected JButton validSelectionInfosButton;
    protected JButton validSpeciesButton;
    protected JButton validStrataButton;
    protected JButton validYearsButton;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSelection")
    protected SwingValidator<Selection> validatorSelection;
    protected CardLayout wizardLayout;
    protected JPanel wizardPanel;
    protected JList yearsList;
    protected YearListModel yearsListModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton10;
    private JButton $JButton2;
    private JButton $JButton3;
    private JButton $JButton4;
    private JButton $JButton5;
    private JButton $JButton6;
    private JButton $JButton7;
    private JButton $JButton8;
    private JButton $JButton9;
    private SelectionReplayView $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JScrollPane $JScrollPane3;
    private JScrollPane $JScrollPane4;
    private JScrollPane $JScrollPane5;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;
    private Table $Table6;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionReplayView(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView() {
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Frame param0) {
        super(param0);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Window param0) {
        super(param0);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionReplayView(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionReplayView(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().finishSelection1toFinal(this);
    }

    public void doActionPerformed__on__$JButton10(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().finishSelection2toFinal(this);
    }

    public void doActionPerformed__on__$JButton4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().finishSelection3toFinal(this);
    }

    public void doActionPerformed__on__$JButton6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().finishSelection4toFinal(this);
    }

    public void doActionPerformed__on__$JButton8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__$JButton9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().finishSelection5toFinal(this);
    }

    public void doActionPerformed__on__validCommandButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionCommand(this);
    }

    public void doActionPerformed__on__validSelectionButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionChoice(this);
    }

    public void doActionPerformed__on__validSelectionInfosButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionInfos(this);
    }

    public void doActionPerformed__on__validSpeciesButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionSpecies(this);
    }

    public void doActionPerformed__on__validStrataButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionStrata(this);
    }

    public void doActionPerformed__on__validYearsButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().validSelectionYears(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setComment(detailsComment.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setName(detailsSelectionNameField.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setDescription(detailsDescription.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSelection().setComment(detailsComment.getText());
    }

    public void doTableChanged__on__errorsTableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSelectionInfosButton.setEnabled(getErrorsTableModel().getRowCount() == 0);
    }

    public void doValueChanged__on__selectedSpeciesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSpeciesButton.setEnabled(selectedSpeciesList.getSelectedIndex() != -1);
    }

    public void doValueChanged__on__selectionByProjectTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validSelectionButton.setEnabled(selectionByProjectTree.getSelectionPath() != null && selectionByProjectTree.getSelectionPath().getPathCount() == 3);
    }

    public void doValueChanged__on__strataList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validStrataButton.setEnabled(strataList.getSelectedIndex() != -1);
    }

    public void doValueChanged__on__yearsList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        validYearsButton.setEnabled(yearsList.getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getCommandList() {
        return commandList;
    }

    public CommandListModel getCommandListModel() {
        return commandListModel;
    }

    public JTextArea getDetailsComment() {
        return detailsComment;
    }

    public JTextArea getDetailsDescription() {
        return detailsDescription;
    }

    public JScrollPane getDetailsDescriptionSP() {
        return detailsDescriptionSP;
    }

    public JTextField getDetailsSelectionNameField() {
        return detailsSelectionNameField;
    }

    public SwingValidatorMessageTableModel getErrorsTableModel() {
        return errorsTableModel;
    }

    public SelectionReplayHandler getHandler() {
        return handler;
    }

    public JTextArea getMessageArea1() {
        return messageArea1;
    }

    public JTextArea getMessageArea2() {
        return messageArea2;
    }

    public JTextArea getMessageArea3() {
        return messageArea3;
    }

    public JTextArea getMessageArea4() {
        return messageArea4;
    }

    public JTextArea getMessageArea5() {
        return messageArea5;
    }

    public Selection getReplayedSelection() {
        return replayedSelection;
    }

    public JList getSelectedSpeciesList() {
        return selectedSpeciesList;
    }

    public SpeciesListModel getSelectedSpeciesListModel() {
        return selectedSpeciesListModel;
    }

    public Selection getSelection() {
        return selection;
    }

    public JTree getSelectionByProjectTree() {
        return selectionByProjectTree;
    }

    public JList getStrataList() {
        return strataList;
    }

    public StrataListModel getStrataListModel() {
        return strataListModel;
    }

    public JButton getValidCommandButton() {
        return validCommandButton;
    }

    public JButton getValidSelectionButton() {
        return validSelectionButton;
    }

    public JButton getValidSelectionInfosButton() {
        return validSelectionInfosButton;
    }

    public JButton getValidSpeciesButton() {
        return validSpeciesButton;
    }

    public JButton getValidStrataButton() {
        return validStrataButton;
    }

    public JButton getValidYearsButton() {
        return validYearsButton;
    }

    public SwingValidator<Selection> getValidatorSelection() {
        return validatorSelection;
    }

    public CardLayout getWizardLayout() {
        return wizardLayout;
    }

    public JPanel getWizardPanel() {
        return wizardPanel;
    }

    public JList getYearsList() {
        return yearsList;
    }

    public YearListModel getYearsListModel() {
        return yearsListModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void setReplayedSelection(Selection replayedSelection) {
        Selection oldValue = this.replayedSelection;
        this.replayedSelection = replayedSelection;
        firePropertyChange(PROPERTY_REPLAYED_SELECTION, oldValue, replayedSelection);
    }

    public void setSelection(Selection selection) {
        Selection oldValue = this.selection;
        this.selection = selection;
        firePropertyChange(PROPERTY_SELECTION, oldValue, selection);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton10() {
        return $JButton10;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JButton get$JButton3() {
        return $JButton3;
    }

    protected JButton get$JButton4() {
        return $JButton4;
    }

    protected JButton get$JButton5() {
        return $JButton5;
    }

    protected JButton get$JButton6() {
        return $JButton6;
    }

    protected JButton get$JButton7() {
        return $JButton7;
    }

    protected JButton get$JButton8() {
        return $JButton8;
    }

    protected JButton get$JButton9() {
        return $JButton9;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected JScrollPane get$JScrollPane4() {
        return $JScrollPane4;
    }

    protected JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    protected Table get$Table6() {
        return $Table6;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDetailsDescriptionSP() {
        if (!allComponentsCreated) {
            return;
        }
        detailsDescriptionSP.getViewport().add(detailsDescription);
    }

    protected void addChildrenToValidatorSelection() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSelection.setErrorTableModel(errorsTableModel);
        validatorSelection.setUiClass(ImageValidationUI.class);
        validatorSelection.setBean(selection);
    }

    protected void addChildrenToWizardPanel() {
        if (!allComponentsCreated) {
            return;
        }
        wizardPanel.add($Table1, "step1");
        wizardPanel.add($Table2, "step2");
        wizardPanel.add($Table3, "step3");
        wizardPanel.add($Table4, "step4");
        wizardPanel.add($Table5, "step5");
        wizardPanel.add($Table6, "step6");
    }

    protected void createCommandList() {
        $objectMap.put("commandList", commandList = new JList());
        
        commandList.setName("commandList");
    }

    protected void createCommandListModel() {
        $objectMap.put("commandListModel", commandListModel = new CommandListModel());
    }

    protected void createDetailsComment() {
        $objectMap.put("detailsComment", detailsComment = new JTextArea());
        
        detailsComment.setName("detailsComment");
        detailsComment.setColumns(15);
        detailsComment.setLineWrap(true);
        detailsComment.setWrapStyleWord(true);
        detailsComment.setRows(3);
    }

    protected void createDetailsDescription() {
        $objectMap.put("detailsDescription", detailsDescription = new JTextArea());
        
        detailsDescription.setName("detailsDescription");
        detailsDescription.setColumns(15);
        detailsDescription.setLineWrap(true);
        detailsDescription.setWrapStyleWord(true);
        detailsDescription.setRows(3);
    }

    protected void createDetailsDescriptionSP() {
        $objectMap.put("detailsDescriptionSP", detailsDescriptionSP = new JScrollPane());
        
        detailsDescriptionSP.setName("detailsDescriptionSP");
    }

    protected void createDetailsSelectionNameField() {
        $objectMap.put("detailsSelectionNameField", detailsSelectionNameField = new JTextField());
        
        detailsSelectionNameField.setName("detailsSelectionNameField");
        detailsSelectionNameField.setColumns(15);
    }

    protected void createErrorsTableModel() {
        $objectMap.put("errorsTableModel", errorsTableModel = new SwingValidatorMessageTableModel());
        
        errorsTableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorsTableModel"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SelectionReplayHandler());
    }

    protected void createMessageArea1() {
        $objectMap.put("messageArea1", messageArea1 = new JTextArea());
        
        messageArea1.setName("messageArea1");
        messageArea1.setColumns(15);
        messageArea1.setLineWrap(true);
        messageArea1.setWrapStyleWord(true);
        messageArea1.setEditable(false);
        messageArea1.setRows(3);
    }

    protected void createMessageArea2() {
        $objectMap.put("messageArea2", messageArea2 = new JTextArea());
        
        messageArea2.setName("messageArea2");
        messageArea2.setColumns(15);
        messageArea2.setLineWrap(true);
        messageArea2.setWrapStyleWord(true);
        messageArea2.setEditable(false);
        messageArea2.setRows(3);
    }

    protected void createMessageArea3() {
        $objectMap.put("messageArea3", messageArea3 = new JTextArea());
        
        messageArea3.setName("messageArea3");
        messageArea3.setColumns(15);
        messageArea3.setLineWrap(true);
        messageArea3.setWrapStyleWord(true);
        messageArea3.setEditable(false);
        messageArea3.setRows(3);
    }

    protected void createMessageArea4() {
        $objectMap.put("messageArea4", messageArea4 = new JTextArea());
        
        messageArea4.setName("messageArea4");
        messageArea4.setColumns(15);
        messageArea4.setLineWrap(true);
        messageArea4.setWrapStyleWord(true);
        messageArea4.setEditable(false);
        messageArea4.setRows(3);
    }

    protected void createMessageArea5() {
        $objectMap.put("messageArea5", messageArea5 = new JTextArea());
        
        messageArea5.setName("messageArea5");
        messageArea5.setColumns(15);
        messageArea5.setLineWrap(true);
        messageArea5.setWrapStyleWord(true);
        messageArea5.setEditable(false);
        messageArea5.setRows(3);
    }

    protected void createReplayedSelection() {
        $objectMap.put("replayedSelection", replayedSelection = null);
    }

    protected void createSelectedSpeciesList() {
        $objectMap.put("selectedSpeciesList", selectedSpeciesList = new JList());
        
        selectedSpeciesList.setName("selectedSpeciesList");
        selectedSpeciesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectedSpeciesList"));
    }

    protected void createSelectedSpeciesListModel() {
        $objectMap.put("selectedSpeciesListModel", selectedSpeciesListModel = new SpeciesListModel());
    }

    protected void createSelection() {
        $objectMap.put("selection", selection = null);
    }

    protected void createSelectionByProjectTree() {
        $objectMap.put("selectionByProjectTree", selectionByProjectTree = new JTree());
        
        selectionByProjectTree.setName("selectionByProjectTree");
        selectionByProjectTree.setRootVisible(false);
        selectionByProjectTree.setShowsRootHandles(true);
        selectionByProjectTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionByProjectTree"));
    }

    protected void createStrataList() {
        $objectMap.put("strataList", strataList = new JList());
        
        strataList.setName("strataList");
        strataList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__strataList"));
    }

    protected void createStrataListModel() {
        $objectMap.put("strataListModel", strataListModel = new StrataListModel());
    }

    protected void createValidCommandButton() {
        $objectMap.put("validCommandButton", validCommandButton = new JButton());
        
        validCommandButton.setName("validCommandButton");
        validCommandButton.setText(_("coser.ui.selection.replay.nextstep"));
        validCommandButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validCommandButton"));
    }

    protected void createValidSelectionButton() {
        $objectMap.put("validSelectionButton", validSelectionButton = new JButton());
        
        validSelectionButton.setName("validSelectionButton");
        validSelectionButton.setEnabled(false);
        validSelectionButton.setText(_("coser.ui.selection.replay.nextstep"));
        validSelectionButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSelectionButton"));
    }

    protected void createValidSelectionInfosButton() {
        $objectMap.put("validSelectionInfosButton", validSelectionInfosButton = new JButton());
        
        validSelectionInfosButton.setName("validSelectionInfosButton");
        validSelectionInfosButton.setEnabled(false);
        validSelectionInfosButton.setText(_("coser.ui.selection.details.saveSelection"));
        validSelectionInfosButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSelectionInfosButton"));
    }

    protected void createValidSpeciesButton() {
        $objectMap.put("validSpeciesButton", validSpeciesButton = new JButton());
        
        validSpeciesButton.setName("validSpeciesButton");
        validSpeciesButton.setEnabled(false);
        validSpeciesButton.setText(_("coser.ui.selection.replay.nextstep"));
        validSpeciesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validSpeciesButton"));
    }

    protected void createValidStrataButton() {
        $objectMap.put("validStrataButton", validStrataButton = new JButton());
        
        validStrataButton.setName("validStrataButton");
        validStrataButton.setEnabled(false);
        validStrataButton.setText(_("coser.ui.selection.replay.nextstep"));
        validStrataButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validStrataButton"));
    }

    protected void createValidYearsButton() {
        $objectMap.put("validYearsButton", validYearsButton = new JButton());
        
        validYearsButton.setName("validYearsButton");
        validYearsButton.setEnabled(false);
        validYearsButton.setText(_("coser.ui.selection.replay.nextstep"));
        validYearsButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validYearsButton"));
    }

    protected void createValidatorSelection() {
        $objectMap.put("validatorSelection", validatorSelection = SwingValidator.newValidator(Selection.class, null));
    }

    protected void createWizardLayout() {
        $objectMap.put("wizardLayout", wizardLayout = new CardLayout());
    }

    protected void createWizardPanel() {
        $objectMap.put("wizardPanel", wizardPanel = new JPanel());
        
        wizardPanel.setName("wizardPanel");
        wizardPanel.setLayout(wizardLayout);
    }

    protected void createYearsList() {
        $objectMap.put("yearsList", yearsList = new JList());
        
        yearsList.setName("yearsList");
        yearsList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__yearsList"));
    }

    protected void createYearsListModel() {
        $objectMap.put("yearsListModel", yearsListModel = new YearListModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(wizardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToValidatorSelection();
        addChildrenToWizardPanel();
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(messageArea1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(validSelectionButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(selectionByProjectTree);
        // inline complete setup of $Table2
        $Table2.add($JLabel1, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(messageArea2, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(validYearsButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JButton3, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(yearsList);
        // inline complete setup of $Table3
        $Table3.add($JLabel2, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JScrollPane2, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(messageArea3, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton4, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(validStrataButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JButton5, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(strataList);
        // inline complete setup of $Table4
        $Table4.add($JLabel3, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane3, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(messageArea4, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JButton6, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(validCommandButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JButton7, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane3
        $JScrollPane3.getViewport().add(commandList);
        // inline complete setup of $Table5
        $Table5.add($JLabel4, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JScrollPane4, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(messageArea5, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JButton8, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(validSpeciesButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add($JButton9, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane4
        $JScrollPane4.getViewport().add(selectedSpeciesList);
        // inline complete setup of $Table6
        $Table6.add($JLabel5, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(SwingUtil.boxComponentWithJxLayer(detailsSelectionNameField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(SwingUtil.boxComponentWithJxLayer(detailsDescriptionSP), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel8, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JScrollPane5, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JButton10, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(validSelectionInfosButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToDetailsDescriptionSP();
        // inline complete setup of $JScrollPane5
        $JScrollPane5.getViewport().add(detailsComment);
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        SwingUtil.setText(messageArea1, _("coser.ui.selection.replay.noerrordetected"));
        
        yearsList.setModel(yearsListModel);
        SwingUtil.setText(messageArea2, _("coser.ui.selection.replay.noerrordetected"));
        
        strataList.setModel(strataListModel);
        SwingUtil.setText(messageArea3, _("coser.ui.selection.replay.noerrordetected"));
        
        commandList.setModel(commandListModel);
        SwingUtil.setText(messageArea4, _("coser.ui.selection.replay.noerrordetected"));
        
        selectedSpeciesList.setModel(selectedSpeciesListModel);
        SwingUtil.setText(messageArea5, _("coser.ui.selection.replay.noerrordetected"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createHandler();
        createSelection();
        createReplayedSelection();
        createErrorsTableModel();
        createValidatorSelection();
        createWizardLayout();
        createWizardPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.selection.replay.chooseselection"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectionByProjectTree();
        createMessageArea1();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createValidSelectionButton();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.selection.replay.finishselection"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.selection.replay.chooseyears"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createYearsListModel();
        createYearsList();
        createMessageArea2();
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(_("coser.ui.common.cancel"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        createValidYearsButton();
        // inline creation of $JButton3
        $objectMap.put("$JButton3", $JButton3 = new JButton());
        
        $JButton3.setName("$JButton3");
        $JButton3.setText(_("coser.ui.selection.replay.finishselection"));
        $JButton3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton3"));
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.selection.replay.choosestrata"));
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createStrataListModel();
        createStrataList();
        createMessageArea3();
        // inline creation of $JButton4
        $objectMap.put("$JButton4", $JButton4 = new JButton());
        
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("coser.ui.common.cancel"));
        $JButton4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton4"));
        createValidStrataButton();
        // inline creation of $JButton5
        $objectMap.put("$JButton5", $JButton5 = new JButton());
        
        $JButton5.setName("$JButton5");
        $JButton5.setText(_("coser.ui.selection.replay.finishselection"));
        $JButton5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton5"));
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.selection.replay.commands"));
        // inline creation of $JScrollPane3
        $objectMap.put("$JScrollPane3", $JScrollPane3 = new JScrollPane());
        
        $JScrollPane3.setName("$JScrollPane3");
        createCommandListModel();
        createCommandList();
        createMessageArea4();
        // inline creation of $JButton6
        $objectMap.put("$JButton6", $JButton6 = new JButton());
        
        $JButton6.setName("$JButton6");
        $JButton6.setText(_("coser.ui.common.cancel"));
        $JButton6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton6"));
        createValidCommandButton();
        // inline creation of $JButton7
        $objectMap.put("$JButton7", $JButton7 = new JButton());
        
        $JButton7.setName("$JButton7");
        $JButton7.setText(_("coser.ui.selection.replay.finishselection"));
        $JButton7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton7"));
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.selection.replay.choosespecies"));
        // inline creation of $JScrollPane4
        $objectMap.put("$JScrollPane4", $JScrollPane4 = new JScrollPane());
        
        $JScrollPane4.setName("$JScrollPane4");
        createSelectedSpeciesListModel();
        createSelectedSpeciesList();
        createMessageArea5();
        // inline creation of $JButton8
        $objectMap.put("$JButton8", $JButton8 = new JButton());
        
        $JButton8.setName("$JButton8");
        $JButton8.setText(_("coser.ui.common.cancel"));
        $JButton8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton8"));
        createValidSpeciesButton();
        // inline creation of $JButton9
        $objectMap.put("$JButton9", $JButton9 = new JButton());
        
        $JButton9.setName("$JButton9");
        $JButton9.setText(_("coser.ui.selection.replay.finishselection"));
        $JButton9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton9"));
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.selection.replay.selectioninfos"));
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("coser.ui.selection.details.name"));
        createDetailsSelectionNameField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = detailsSelectionNameField.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("coser.ui.selection.details.description"));
        createDetailsDescriptionSP();
        createDetailsDescription();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = detailsDescription.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("coser.ui.selection.details.comment"));
        // inline creation of $JScrollPane5
        $objectMap.put("$JScrollPane5", $JScrollPane5 = new JScrollPane());
        
        $JScrollPane5.setName("$JScrollPane5");
        createDetailsComment();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = detailsComment.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JButton10
        $objectMap.put("$JButton10", $JButton10 = new JButton());
        
        $JButton10.setName("$JButton10");
        $JButton10.setText(_("coser.ui.common.cancel"));
        $JButton10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton10"));
        createValidSelectionInfosButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        SwingUtil.setComponentHeight($JDialog0,500);
        setTitle(_("coser.ui.selection.replay.replayTitle"));
        SwingUtil.setComponentWidth($JDialog0,600);
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON1_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validSelectionButton != null) {
                    validSelectionButton.addPropertyChangeListener("enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validSelectionButton != null) {
                    $JButton1.setEnabled(validSelectionButton.isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validSelectionButton != null) {
                    validSelectionButton.removePropertyChangeListener("enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_YEARS_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (yearsList != null) {
                    yearsList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (yearsList != null) {
                    yearsList.setSelectionModel(new CoserListSelectionModel(yearsList.getSelectionModel(), yearsListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (yearsList != null) {
                    yearsList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON3_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validYearsButton != null) {
                    validYearsButton.addPropertyChangeListener("enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validYearsButton != null) {
                    $JButton3.setEnabled(validYearsButton.isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validYearsButton != null) {
                    validYearsButton.removePropertyChangeListener("enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (strataList != null) {
                    strataList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (strataList != null) {
                    strataList.setSelectionModel(new CoserListSelectionModel(strataList.getSelectionModel(), strataListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (strataList != null) {
                    strataList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON5_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validStrataButton != null) {
                    validStrataButton.addPropertyChangeListener("enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validStrataButton != null) {
                    $JButton5.setEnabled(validStrataButton.isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validStrataButton != null) {
                    validStrataButton.removePropertyChangeListener("enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON7_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validCommandButton != null) {
                    validCommandButton.addPropertyChangeListener("enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validCommandButton != null) {
                    $JButton7.setEnabled(validCommandButton.isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validCommandButton != null) {
                    validCommandButton.removePropertyChangeListener("enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SELECTED_SPECIES_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.setSelectionModel(new CoserListSelectionModel(selectedSpeciesList.getSelectionModel(), selectedSpeciesListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (selectedSpeciesList != null) {
                    selectedSpeciesList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON9_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validSpeciesButton != null) {
                    validSpeciesButton.addPropertyChangeListener("enabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validSpeciesButton != null) {
                    $JButton9.setEnabled(validSpeciesButton.isEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validSpeciesButton != null) {
                    validSpeciesButton.removePropertyChangeListener("enabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_SELECTION_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsSelectionNameField, getSelection().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_DESCRIPTION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsDescription, getSelection().getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DETAILS_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getSelection() != null) {
                    SwingUtil.setText(detailsComment, getSelection().getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("selection", this);
                if (getSelection() != null) {
                    getSelection().removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}