/*
 * #%L
 * Coser :: UI
 * 
 * $Id: CoserConfig.java 899 2011-11-17 14:22:11Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.3/coser-ui/src/main/java/fr/ifremer/coser/CoserConfig.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.coser;

import static org.nuiton.i18n.I18n._;

import java.awt.Font;
import java.util.Enumeration;

import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Coser application configuration.
 * 
 * @author chatellier
 * @version $Revision: 899 $
 * 
 * Last update : $Date: 2011-11-17 15:22:11 +0100 (Thu, 17 Nov 2011) $
 * By : $Author: echatellier $
 */
public class CoserConfig extends CoserBusinessConfig {

    private static final Log log = LogFactory.getLog(CoserConfig.class);

    public CoserConfig() {
        // init configuration with default options
        for (CoserOption o : CoserOption.values()) {
            if (o.defaultValue != null) {
                setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public String getLookAndFeel() {
        String className = getOption(CoserOption.LOOKANDFEEL.key);
        return className;
    }

    public void setLookAndFeel(String lookAndFeel) {
        setOption(CoserOption.LOOKANDFEEL.key, lookAndFeel);
    }

    public String getApplicationVersion() {
        String result = getOption(CoserOption.APPLICATION_VERSION.key);
        return result;
    }

    public void setSupportEmail(String supportEmail) {
        setOption(CoserOption.SUPPORT_EMAIL.key, supportEmail);
    }

    public String getSupportEmail() {
        String result = getOption(CoserOption.SUPPORT_EMAIL.key);
        return result;
    }

    public String getWebsiteURL() {
        String result = getOption(CoserOption.WEBSITE_URL.key);
        return result;
    }

    public int getSwingFontSize() {
        int result = getOptionAsInt(CoserOption.SWING_FONT_SIZE.key);
        return result;
    }

    public void setSwingFontSize(int swingFontSize) {
        int old = getSwingFontSize();
        if (old != swingFontSize) {
            setOption(CoserOption.SWING_FONT_SIZE.key, String.valueOf(swingFontSize));
            updateSwingFont(swingFontSize);
        }
    }

    public static enum CoserOption implements OptionDef {

        CONFIG_FILE(CONFIG_FILE_NAME, _("coser.config.config.file.description"), "coser.properties", String.class, true, true),
        LOOKANDFEEL("coser.lookandfeel", _("coser.config.lookandfeel.description"), null, String.class, false, false),
        APPLICATION_VERSION("coser.application.version", _("coser.config.application.version.description"), null, String.class, false, false),
        SUPPORT_EMAIL("coser.support.email", _("coser.config.support.email.description"), "support@codelutin.com", String.class, false, false),
        WEBSITE_URL("coser.website", _("coser.config.website.description"), "http://maven-site.forge.codelutin.com/coser/", String.class, false, false),
        SWING_FONT_SIZE("coser.swingfontsize", _("coser.config.swingfontsize.description"), "12", Integer.class, false, false);

        protected String key;
        protected String description;
        protected String defaultValue;
        protected Class<?> type;
        protected boolean isTransient;
        protected boolean isFinal;

        private CoserOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        @Override
        public boolean isFinal() {
            return isFinal;
        }

        @Override
        public boolean isTransient() {
            return isTransient;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public String getDescription() {
            return description;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        @Override
        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }
    }

    /**
     * Update swing fonts properties.
     */
    public void updateSwingFont() {
        updateSwingFont(getSwingFontSize());
    }

    /**
     * Update swing fonts properties.
     * 
     * @param newIncrease increase gap to apply to font
     */
    protected void updateSwingFont(int newIncrease) {
        // update all font properties
        Enumeration<Object> keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            // Application.useSystemFontSettings exists on windows
            if (key.toString().endsWith("Font") || key.toString().endsWith(".font")) {
                Font font = (Font)UIManager.getFont(key);
                if (log.isDebugEnabled()) {
                    log.debug("Update " + key + " to size " + newIncrease);
                }
                font = font.deriveFont((float)newIncrease);
                UIManager.put(key, new FontUIResource(font));
            }
        }
    }
}
