/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.manager.tasks.GetProjectsForBranch;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ReactorProjectsProvider;
import com.atlassian.maven.plugins.jgitflow.provider.VersionCacheProvider;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdateDevelopPomsWithMasterVersion.class)
public class UpdateDevelopPomsWithMasterVersion
implements ExtensionCommand {
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private BranchHelper branchHelper;
    @Requirement
    private GetProjectsForBranch getProjectsForBranch;
    @Requirement
    private ReactorProjectsProvider reactorProjectsProvider;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private VersionCacheProvider versionCacheProvider;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand, JGitFlowReporter reporter) throws JGitFlowExtensionException {
        try {
            String originalBranchName = this.branchHelper.getCurrentBranchName();
            ReleaseContext ctx = this.contextProvider.getContext();
            JGitFlow flow = this.jGitFlowProvider.gitFlow();
            List<MavenProject> developProjects = this.getProjectsForBranch.run(flow.getDevelopBranchName(), this.reactorProjectsProvider.getReactorProjects());
            List<MavenProject> masterProjects = this.getProjectsForBranch.run(flow.getMasterBranchName(), this.reactorProjectsProvider.getReactorProjects());
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            this.versionCacheProvider.cacheCurrentBranchVersions();
            this.pomUpdater.copyPomVersionsFromProject(masterProjects, developProjects);
            this.projectHelper.commitAllPoms(flow.git(), developProjects, ctx.getScmCommentPrefix() + "updating develop poms to master versions to avoid merge conflicts" + ctx.getScmCommentSuffix());
            flow.git().checkout().setName(originalBranchName).call();
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating release poms to develop version", (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return null;
    }
}

