/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.jgitflow.api.MavenReleaseStartExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="release-start", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ReleaseStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(property="releaseVersion", defaultValue="")
    private String releaseVersion = "";
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(property="releaseBranchVersionSuffix", defaultValue="")
    private String releaseBranchVersionSuffix = "";
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(defaultValue="false", property="pushReleases")
    private boolean pushReleases = false;
    @Component(hint="release")
    FlowReleaseManager releaseManager;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit = "";
    @Parameter(defaultValue="")
    private String releaseStartExtension = "";

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassloader(this.getClasspath()));
        MavenReleaseStartExtension extensionObject = (MavenReleaseStartExtension)this.getExtensionInstance(this.releaseStartExtension);
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setAutoVersionSubmodules(this.autoVersionSubmodules).setInteractive(this.getSettings().isInteractiveMode()).setDefaultReleaseVersion(this.releaseVersion).setDefaultDevelopmentVersion(this.developmentVersion).setReleaseBranchVersionSuffix(this.releaseBranchVersionSuffix).setAllowSnapshots(this.allowSnapshots).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushReleases(this.pushReleases).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setDefaultOriginUrl(this.defaultOriginUrl).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setReleaseStartExtension(extensionObject).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error starting release: " + e.getMessage(), (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }
}

