/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PDObject
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Type = COSName.constant("Type");
    public static final COSName DK_Subtype = COSName.constant("Subtype");

    protected PDObject(COSObject object) {
        super(object);
    }

    protected COSName cosGetExpectedSubtype() {
        return null;
    }

    protected COSName cosGetExpectedType() {
        return null;
    }

    public COSObject cosGetFieldDescendant(COSName name) {
        List children;
        COSObject cosBase = this.cosGetField(name);
        if (cosBase.isNull() && (children = this.getGenericChildren()) != null) {
            for (PDObject child : children) {
                cosBase = child.cosGetFieldDescendant(name);
                if (cosBase.isNull()) continue;
                return cosBase;
            }
        }
        return cosBase;
    }

    public COSObject cosGetFieldInheritable(COSName name) {
        COSObject cosBase = this.cosGetField(name);
        if (cosBase.isNull() && this.getGenericParent() != null) {
            return this.getGenericParent().cosGetFieldInheritable(name);
        }
        return cosBase;
    }

    public COSObject cosGetFieldInherited(COSName name) {
        if (this.getGenericParent() != null) {
            return this.getGenericParent().cosGetFieldInheritable(name);
        }
        return COSNull.NULL;
    }

    public final COSName cosGetSubtype() {
        return this.cosGetDict().get(DK_Subtype).asName();
    }

    public final COSName cosGetType() {
        return this.cosGetField(DK_Type).asName();
    }

    public COSObject cosRemoveFieldInheritable(COSName name) {
        COSObject result = this.cosRemoveField(name);
        List children = this.getGenericChildren();
        if (children != null) {
            for (PDObject child : children) {
                child.cosRemoveFieldInheritable(name);
            }
        }
        return result;
    }

    public COSObject cosSetFieldInheritable(COSName name, COSObject cosObj) {
        COSObject result = this.cosSetField(name, cosObj);
        List children = this.getGenericChildren();
        if (children != null) {
            for (PDObject child : children) {
                child.cosRemoveFieldInheritable(name);
            }
        }
        return result;
    }

    public final COSName cosSetSubtype(COSName newType) {
        return this.cosSetField(DK_Subtype, newType).asName();
    }

    public final COSName cosSetType(COSName newType) {
        return this.cosSetField(DK_Type, newType).asName();
    }

    public PDDocument getDoc() {
        COSDocument cosDoc = this.cosGetObject().getDoc();
        if (cosDoc == null) {
            return null;
        }
        return PDDocument.createFromCos(cosDoc);
    }

    public List getGenericChildren() {
        return null;
    }

    public PDObject getGenericParent() {
        return null;
    }

    protected List getPDObjects(COSName key, COSBasedObject.MetaClass metaclass, boolean addListener) {
        COSArray array = this.cosGetField(key).asArray();
        if (array != null) {
            ArrayList<COSBasedObject> result = new ArrayList<COSBasedObject>();
            Iterator i = array.iterator();
            while (i.hasNext()) {
                COSBasedObject pdObject = metaclass.createFromCos((COSObject)i.next());
                if (pdObject == null) continue;
                result.add(pdObject);
            }
            if (addListener) {
                array.addObjectListener(this);
            }
            return result;
        }
        return null;
    }

    protected void initializeFromScratch() {
        COSName subtype;
        super.initializeFromScratch();
        COSName type = this.cosGetExpectedType();
        if (type != null) {
            this.cosSetField(DK_Type, type.copyShallow());
        }
        if ((subtype = this.cosGetExpectedSubtype()) != null) {
            this.cosSetField(DK_Subtype, subtype.copyShallow());
        }
    }

    public void setGenericParent(PDObject parent) {
    }

    protected void setPDObjects(COSName key, List list) {
        if (list == null) {
            this.cosRemoveField(key);
            return;
        }
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            array = COSArray.create();
        } else {
            array.clear();
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            array.add(((PDObject)i.next()).cosGetDict());
        }
        this.cosSetField(key, array);
    }

    public String toString() {
        if (this.cosGetObject() == null) {
            return "a " + this.getClass().getName();
        }
        if (this.cosGetObject().isIndirect()) {
            return "[" + this.cosGetObject().getIndirectObject().toString() + "] " + this.getClass().getName();
        }
        return "a " + this.getClass().getName();
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

