/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDAppearance
extends PDObject {
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName DK_N = COSName.constant("N");
    public static final COSName DK_R = COSName.constant("R");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    protected PDAppearance(COSObject object) {
        super(object);
    }

    protected void collectAppearances(COSDictionary dict, List<PDForm> forms) {
        for (COSObject entry : dict.values()) {
            PDForm form;
            if (entry.isNull()) continue;
            if (entry instanceof COSStream && (form = (PDForm)PDForm.META.createFromCos(entry)) != null) {
                forms.add(form);
            }
            if (!(entry instanceof COSDictionary)) continue;
            COSDictionary entryDict = (COSDictionary)entry;
            this.collectAppearances(entryDict, forms);
        }
    }

    public PDForm getAppearance(COSName key, COSName state) {
        PDForm form = this.getForm(key, state);
        if (form == null) {
            form = this.getNormalAppearance(state);
        }
        return form;
    }

    public PDForm getDownAppearance(COSName state) {
        return this.getForm(DK_D, state);
    }

    protected PDForm getForm(COSName key, COSName state) {
        COSObject cosObject = this.cosGetField(key);
        if (cosObject.isNull()) {
            return null;
        }
        if (cosObject instanceof COSStream) {
            return (PDForm)PDForm.META.createFromCos(cosObject);
        }
        if (cosObject instanceof COSDictionary && state != null) {
            COSDictionary dict = (COSDictionary)cosObject;
            COSStream stream = dict.get(state).asStream();
            return (PDForm)PDForm.META.createFromCos(stream);
        }
        return null;
    }

    public List<PDForm> getForms() {
        ArrayList<PDForm> forms = new ArrayList<PDForm>();
        this.collectAppearances(this.cosGetDict(), forms);
        return forms;
    }

    public PDForm getNormalAppearance(COSName state) {
        return this.getForm(DK_N, state);
    }

    public PDForm getRolloverAppearance(COSName state) {
        return this.getForm(DK_R, state);
    }

    public boolean isDefined() {
        return this.getNormalAppearance(null) != null;
    }

    public boolean isDefined(COSName key, COSName state) {
        PDForm form = this.getForm(key, state);
        if (form == null) {
            form = this.getNormalAppearance(state);
        }
        return form != null;
    }

    public void setDownAppearance(COSName state, PDForm form) {
        this.setForm(DK_D, state, form);
    }

    protected void setForm(COSName key, COSName state, PDForm form) {
        COSObject cosObject = this.cosGetField(key);
        if (state == null) {
            if (form != null) {
                this.cosSetField(key, form.cosGetStream());
            } else {
                this.cosRemoveField(key);
            }
        } else {
            if (!(cosObject instanceof COSDictionary)) {
                cosObject = COSDictionary.create();
                this.cosSetField(key, cosObject);
            }
            COSDictionary dict = (COSDictionary)cosObject;
            if (form != null) {
                dict.put(state, form.cosGetStream());
            } else {
                dict.remove(state);
            }
        }
    }

    public void setNormalAppearance(COSName state, PDForm form) {
        this.setForm(DK_N, state, form);
    }

    public void setRolloverAppearance(COSName state, PDForm form) {
        this.setForm(DK_R, state, form);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAppearance(object);
        }

        protected boolean isIndirect() {
            return false;
        }
    }
}

