/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public class StringLocator
extends CommonLocator {
    private final String content;
    private String encoding = System.getProperty("file.encoding");
    private String localName;
    private String type;

    public StringLocator(String content, String name, String type) {
        this.content = content;
        this.localName = name;
        this.type = type;
    }

    public void delete() throws IOException {
    }

    public boolean exists() {
        return this.getContent() != null;
    }

    protected byte[] getBytes() {
        byte[] bytes;
        try {
            bytes = this.getContent().getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            bytes = this.getContent().getBytes();
        }
        return bytes;
    }

    public ILocator getChild(String child) {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        if (this.getType() == null) {
            return this.getLocalName();
        }
        return String.valueOf(this.getLocalName()) + "." + this.getType();
    }

    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public long getLength() throws IOException {
        return this.getBytes().length;
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        byte[] bytes = this.getBytes();
        return new RandomAccessByteArray(bytes);
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.getContent());
    }

    public Reader getReader(String encoding) throws IOException {
        return new StringReader(this.getContent());
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    public Writer getWriter(String encoding) throws IOException {
        throw new IOException("locator is read only");
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    public void rename(String newName) throws IOException {
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName, this.getType());
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }
}

