/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassLoaderResourceLocator
extends CommonLocator {
    private final ClassLoader classLoader;
    private final String name;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassLoaderResourceLocator(ClassLoader classLoader, String name) {
        this.classLoader = classLoader;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassLoaderResourceLocator)) {
            return false;
        }
        return this.getName().equals(((ClassLoaderResourceLocator)obj).getName());
    }

    public boolean exists() {
        return this.getClassLoader().getResource(this.getName()) != null;
    }

    public ILocator getChild(String childName) {
        String child = String.valueOf(this.getName()) + "/" + childName;
        ClassLoaderResourceLocator result = new ClassLoaderResourceLocator(this.getClassLoader(), child);
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        return this.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.getClassLoader().getResourceAsStream(this.getName());
    }

    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    public ILocator getParent() {
        int index = this.getName().lastIndexOf("/");
        if (index > -1) {
            String parentname = this.getName().substring(0, index);
            return new ClassLoaderResourceLocator(this.getClassLoader(), parentname);
        }
        return null;
    }

    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    public Reader getReader(String newEncoding) throws IOException {
        if (newEncoding == null || newEncoding.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    public Writer getWriter(String pEncoding) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void synch() {
    }

    public String toString() {
        return this.getName();
    }

    public URL toURL() {
        return null;
    }
}

